/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Processor;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.processor.AOPProcessor;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="aop")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AOPDefinition
extends OutputDefinition<ProcessorDefinition> {
    @XmlAttribute(required=false)
    private String beforeUri;
    @XmlAttribute(required=false)
    private String afterUri;
    @XmlAttribute(required=false)
    private String afterFinallyUri;

    public String toString() {
        return "AOP[" + this.getOutputs() + "]";
    }

    public String getBeforeUri() {
        return this.beforeUri;
    }

    public String getAfterUri() {
        return this.afterUri;
    }

    public String getAfterFinallyUri() {
        return this.afterFinallyUri;
    }

    @Override
    public String getShortName() {
        return "aop";
    }

    @Override
    public String getLabel() {
        return "aop";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        if (this.beforeUri == null && this.afterUri == null && this.afterFinallyUri == null) {
            throw new IllegalArgumentException("At least one of before, after or afterFinally must be provided on: " + this);
        }
        ArrayList<ProcessorDefinition> pipe = new ArrayList<ProcessorDefinition>();
        Processor finallyProcessor = null;
        if (this.beforeUri != null) {
            pipe.add(new ToDefinition(this.beforeUri));
        }
        pipe.addAll(this.getOutputs());
        if (this.afterUri != null) {
            pipe.add(new ToDefinition(this.afterUri));
        } else if (this.afterFinallyUri != null) {
            finallyProcessor = new ToDefinition(this.afterFinallyUri).createProcessor(routeContext);
        }
        Processor tryProcessor = this.createOutputsProcessor(routeContext, pipe);
        return new AOPProcessor(tryProcessor, null, finallyProcessor);
    }

    public AOPDefinition around(String beforeUri, String afterUri) {
        this.beforeUri = beforeUri;
        this.afterUri = afterUri;
        this.afterFinallyUri = null;
        return this;
    }

    public AOPDefinition aroundFinally(String beforeUri, String afterUri) {
        this.beforeUri = beforeUri;
        this.afterUri = null;
        this.afterFinallyUri = afterUri;
        return this;
    }

    public AOPDefinition before(String beforeUri) {
        this.beforeUri = beforeUri;
        this.afterUri = null;
        this.afterFinallyUri = null;
        return this;
    }

    public AOPDefinition after(String afterUri) {
        this.beforeUri = null;
        this.afterUri = afterUri;
        this.afterFinallyUri = null;
        return this;
    }

    public AOPDefinition afterFinally(String afterUri) {
        this.beforeUri = null;
        this.afterUri = null;
        this.afterFinallyUri = afterUri;
        return this;
    }
}

