/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Channel;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.DataFormatClause;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.builder.ProcessorBuilder;
import org.apache.camel.model.AOPDefinition;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.Block;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ConvertBodyDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.DelayDefinition;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.FinallyDefinition;
import org.apache.camel.model.IdempotentConsumerDefinition;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.LoopDefinition;
import org.apache.camel.model.MarshalDefinition;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.NodeFactory;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.PipelineDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.PollEnrichDefinition;
import org.apache.camel.model.ProcessDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.model.RemoveHeaderDefinition;
import org.apache.camel.model.RemovePropertyDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.RollbackDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.model.SamplingDefinition;
import org.apache.camel.model.SetBodyDefinition;
import org.apache.camel.model.SetExchangePatternDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.SetOutHeaderDefinition;
import org.apache.camel.model.SetPropertyDefinition;
import org.apache.camel.model.SortDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.StopDefinition;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.camel.model.ThrottleDefinition;
import org.apache.camel.model.ThrowExceptionDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.TransformDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.model.UnmarshalDefinition;
import org.apache.camel.model.WireTapDefinition;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.LanguageExpression;
import org.apache.camel.processor.DefaultChannel;
import org.apache.camel.processor.InterceptEndpointProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.aggregate.AggregationCollection;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.interceptor.Delayer;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.processor.interceptor.StreamCaching;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public abstract class ProcessorDefinition<Type extends ProcessorDefinition>
extends OptionalIdentifiedDefinition
implements Block {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected ErrorHandlerBuilder errorHandlerBuilder;
    protected String errorHandlerRef;
    private NodeFactory nodeFactory;
    private final LinkedList<Block> blocks = new LinkedList();
    private ProcessorDefinition<?> parent;
    private final List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();

    public abstract List<ProcessorDefinition> getOutputs();

    public Processor createProcessor(RouteContext routeContext) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet for class: " + this.getClass().getName());
    }

    public Processor createOutputsProcessor(RouteContext routeContext) throws Exception {
        List<ProcessorDefinition> outputs = this.getOutputs();
        return this.createOutputsProcessor(routeContext, outputs);
    }

    @Override
    public void addOutput(ProcessorDefinition processorType) {
        processorType.setParent(this);
        this.configureChild(processorType);
        if (this.blocks.isEmpty()) {
            this.getOutputs().add(processorType);
        } else {
            Block block = this.blocks.getLast();
            block.addOutput(processorType);
        }
    }

    public void clearOutput() {
        this.getOutputs().clear();
        this.blocks.clear();
    }

    public void addRoutes(RouteContext routeContext, Collection<Route> routes) throws Exception {
        Processor processor = this.makeProcessor(routeContext);
        if (processor == null) {
            return;
        }
        if (!routeContext.isRouteAdded()) {
            Channel channel;
            Processor next;
            boolean endpointInterceptor = false;
            if (processor instanceof Channel && (next = (channel = (Channel)processor).getNextProcessor()) instanceof InterceptEndpointProcessor) {
                endpointInterceptor = true;
            }
            if (endpointInterceptor) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Endpoint interceptor should not be added as an event driven consumer route: " + processor));
                }
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Adding event driven processor: " + processor));
                }
                routeContext.addEventDrivenProcessor(processor);
            }
        }
    }

    public Processor wrapProcessor(RouteContext routeContext, Processor processor) throws Exception {
        if (processor instanceof Channel) {
            return processor;
        }
        return this.wrapChannel(routeContext, processor, null);
    }

    protected Processor wrapChannel(RouteContext routeContext, Processor processor, ProcessorDefinition child) throws Exception {
        Channel channel = this.createChannel(routeContext);
        channel.setNextProcessor(processor);
        this.addInterceptStrategies(routeContext, channel, routeContext.getCamelContext().getInterceptStrategies());
        this.addInterceptStrategies(routeContext, channel, routeContext.getInterceptStrategies());
        if (routeContext.getManagedInterceptStrategy() != null) {
            channel.addInterceptStrategy(routeContext.getManagedInterceptStrategy());
        }
        this.addInterceptStrategies(routeContext, channel, this.getInterceptStrategies());
        ProcessorDefinition defn = this;
        channel.setChildDefinition(child);
        channel.initChannel(defn, routeContext);
        if (defn instanceof TryDefinition || defn instanceof CatchDefinition || defn instanceof FinallyDefinition) {
            return channel;
        }
        Processor output = channel.getOutput();
        ErrorHandlerBuilder builder = this.getErrorHandlerBuilder();
        Processor errorHandler = builder.createErrorHandler(routeContext, output);
        channel.setErrorHandler(errorHandler);
        for (LifecycleStrategy strategy : routeContext.getCamelContext().getLifecycleStrategies()) {
            strategy.onErrorHandlerAdd(routeContext, errorHandler, builder);
        }
        return channel;
    }

    protected void addInterceptStrategies(RouteContext routeContext, Channel channel, List<InterceptStrategy> strategies) {
        for (InterceptStrategy strategy : strategies) {
            if (!routeContext.isStreamCaching() && strategy instanceof StreamCaching || !routeContext.isHandleFault() && strategy instanceof HandleFault) continue;
            if (strategy instanceof Delayer) {
                if (routeContext.getDelayer() == null || routeContext.getDelayer() <= 0L) continue;
                Iterator<InterceptStrategy> it = channel.getInterceptStrategies().iterator();
                while (it.hasNext()) {
                    InterceptStrategy existing = it.next();
                    if (!(existing instanceof Delayer)) continue;
                    it.remove();
                }
                channel.addInterceptStrategy(strategy);
                continue;
            }
            channel.addInterceptStrategy(strategy);
        }
    }

    protected Processor createCompositeProcessor(RouteContext routeContext, List<Processor> list) {
        return new Pipeline(list);
    }

    protected Channel createChannel(RouteContext routeContext) {
        return new DefaultChannel();
    }

    protected Processor createOutputsProcessor(RouteContext routeContext, Collection<ProcessorDefinition> outputs) throws Exception {
        ArrayList<Processor> list = new ArrayList<Processor>();
        for (ProcessorDefinition output : outputs) {
            Processor processor = output.createProcessor(routeContext);
            if (output instanceof Channel && processor == null) continue;
            Processor channel = this.wrapChannel(routeContext, processor, output);
            list.add(channel);
        }
        Processor processor = null;
        if (!list.isEmpty()) {
            processor = list.size() == 1 ? (Processor)list.get(0) : this.createCompositeProcessor(routeContext, list);
        }
        return processor;
    }

    protected Processor makeProcessor(RouteContext routeContext) throws Exception {
        Processor processor = this.createProcessor(routeContext);
        if (processor == null) {
            return null;
        }
        return this.wrapProcessor(routeContext, processor);
    }

    protected ErrorHandlerBuilder createErrorHandlerBuilder() {
        if (this.errorHandlerRef != null) {
            return new ErrorHandlerBuilderRef(this.errorHandlerRef);
        }
        return new ErrorHandlerBuilderRef("CamelDefaultErrorHandlerBuilder");
    }

    protected void configureChild(ProcessorDefinition output) {
        output.setNodeFactory(this.getNodeFactory());
        output.setErrorHandlerBuilder(this.getErrorHandlerBuilder());
    }

    public Type to(String uri) {
        this.addOutput(new ToDefinition(uri));
        return (Type)this;
    }

    public Type toF(String uri, Object ... args) {
        this.addOutput(new ToDefinition(String.format(uri, args)));
        return (Type)this;
    }

    public Type to(Endpoint endpoint) {
        this.addOutput(new ToDefinition(endpoint));
        return (Type)this;
    }

    public Type to(ExchangePattern pattern, String uri) {
        this.addOutput(new ToDefinition(uri, pattern));
        return (Type)this;
    }

    public Type to(ExchangePattern pattern, Endpoint endpoint) {
        this.addOutput(new ToDefinition(endpoint, pattern));
        return (Type)this;
    }

    public Type to(String ... uris) {
        for (String uri : uris) {
            this.addOutput(new ToDefinition(uri));
        }
        return (Type)this;
    }

    public Type to(Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint));
        }
        return (Type)this;
    }

    public Type to(Iterable<Endpoint> endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint));
        }
        return (Type)this;
    }

    public Type to(ExchangePattern pattern, String ... uris) {
        for (String uri : uris) {
            this.addOutput(new ToDefinition(uri, pattern));
        }
        return (Type)this;
    }

    public Type to(ExchangePattern pattern, Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint, pattern));
        }
        return (Type)this;
    }

    public Type to(ExchangePattern pattern, Iterable<Endpoint> endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint, pattern));
        }
        return (Type)this;
    }

    public ToDefinition toAsync(String uri) {
        ToDefinition answer = new ToDefinition(uri);
        answer.setAsync(true);
        this.addOutput(answer);
        this.pushBlock(answer);
        return answer;
    }

    public ToDefinition toAsync(String uri, int poolSize) {
        ToDefinition answer = new ToDefinition(uri);
        answer.setAsync(true);
        answer.setPoolSize(poolSize);
        this.addOutput(answer);
        this.pushBlock(answer);
        return answer;
    }

    public ToDefinition toAsync(Endpoint endpoint) {
        ToDefinition answer = new ToDefinition(endpoint);
        answer.setAsync(true);
        this.addOutput(answer);
        this.pushBlock(answer);
        return answer;
    }

    public ToDefinition toAsync(Endpoint endpoint, int poolSize) {
        ToDefinition answer = new ToDefinition(endpoint);
        answer.setAsync(true);
        answer.setPoolSize(poolSize);
        this.addOutput(answer);
        this.pushBlock(answer);
        return answer;
    }

    public Type setExchangePattern(ExchangePattern exchangePattern) {
        this.addOutput(new SetExchangePatternDefinition(exchangePattern));
        return (Type)this;
    }

    public Type inOnly() {
        return this.setExchangePattern(ExchangePattern.InOnly);
    }

    public Type inOnly(String uri) {
        return this.to(ExchangePattern.InOnly, uri);
    }

    public Type inOnly(Endpoint endpoint) {
        return this.to(ExchangePattern.InOnly, endpoint);
    }

    public Type inOnly(String ... uris) {
        return this.to(ExchangePattern.InOnly, uris);
    }

    public Type inOnly(Endpoint ... endpoints) {
        return this.to(ExchangePattern.InOnly, endpoints);
    }

    public Type inOnly(Iterable<Endpoint> endpoints) {
        return this.to(ExchangePattern.InOnly, endpoints);
    }

    public Type inOut() {
        return this.setExchangePattern(ExchangePattern.InOut);
    }

    public Type inOut(String uri) {
        return this.to(ExchangePattern.InOut, uri);
    }

    public Type inOut(Endpoint endpoint) {
        return this.to(ExchangePattern.InOut, endpoint);
    }

    public Type inOut(String ... uris) {
        return this.to(ExchangePattern.InOut, uris);
    }

    public Type inOut(Endpoint ... endpoints) {
        return this.to(ExchangePattern.InOut, endpoints);
    }

    public Type inOut(Iterable<Endpoint> endpoints) {
        return this.to(ExchangePattern.InOut, endpoints);
    }

    public Type id(String id) {
        if (this.getOutputs().isEmpty()) {
            this.setId(id);
        } else {
            this.getOutputs().get(this.getOutputs().size() - 1).setId(id);
        }
        return (Type)this;
    }

    public Type routeId(String id) {
        ProcessorDefinition def = this;
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(def);
        if (route != null) {
            route.setId(id);
        }
        return (Type)this;
    }

    public MulticastDefinition multicast() {
        MulticastDefinition answer = new MulticastDefinition();
        this.addOutput(answer);
        return answer;
    }

    public MulticastDefinition multicast(AggregationStrategy aggregationStrategy, boolean parallelProcessing) {
        MulticastDefinition answer = new MulticastDefinition();
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        answer.setParallelProcessing(parallelProcessing);
        return answer;
    }

    public MulticastDefinition multicast(AggregationStrategy aggregationStrategy) {
        MulticastDefinition answer = new MulticastDefinition();
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        return answer;
    }

    public PipelineDefinition pipeline() {
        PipelineDefinition answer = new PipelineDefinition();
        this.addOutput(answer);
        return answer;
    }

    public Type pipeline(String ... uris) {
        return this.to(uris);
    }

    public Type pipeline(Endpoint ... endpoints) {
        return this.to(endpoints);
    }

    public Type pipeline(Collection<Endpoint> endpoints) {
        return this.to(endpoints);
    }

    public ThreadsDefinition threads() {
        ThreadsDefinition answer = new ThreadsDefinition();
        this.addOutput(answer);
        return answer;
    }

    public ThreadsDefinition threads(int poolSize) {
        ThreadsDefinition answer = this.threads();
        answer.setPoolSize(poolSize);
        return answer;
    }

    public AOPDefinition aop() {
        AOPDefinition answer = new AOPDefinition();
        this.addOutput(answer);
        return answer;
    }

    public ProcessorDefinition end() {
        ProcessorDefinition defn = this;
        if (defn instanceof TryDefinition) {
            this.popBlock();
        }
        if (this.blocks.isEmpty()) {
            if (this.parent == null) {
                return this;
            }
            return this.parent;
        }
        this.popBlock();
        return this;
    }

    public IdempotentConsumerDefinition idempotentConsumer() {
        IdempotentConsumerDefinition answer = new IdempotentConsumerDefinition();
        this.addOutput(answer);
        return answer;
    }

    public IdempotentConsumerDefinition idempotentConsumer(Expression messageIdExpression, IdempotentRepository<?> idempotentRepository) {
        IdempotentConsumerDefinition answer = new IdempotentConsumerDefinition(messageIdExpression, idempotentRepository);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<IdempotentConsumerDefinition> idempotentConsumer(IdempotentRepository<?> idempotentRepository) {
        IdempotentConsumerDefinition answer = new IdempotentConsumerDefinition();
        answer.setMessageIdRepository(idempotentRepository);
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public ExpressionClause<FilterDefinition> filter() {
        FilterDefinition filter = new FilterDefinition();
        this.addOutput(filter);
        return ExpressionClause.createAndSetExpression(filter);
    }

    public FilterDefinition filter(Predicate predicate) {
        FilterDefinition filter = new FilterDefinition(predicate);
        this.addOutput(filter);
        return filter;
    }

    public FilterDefinition filter(ExpressionDefinition expression) {
        FilterDefinition filter = this.getNodeFactory().createFilter();
        filter.setExpression(expression);
        this.addOutput(filter);
        return filter;
    }

    public FilterDefinition filter(String language, String expression) {
        return this.filter(new LanguageExpression(language, expression));
    }

    public LoadBalanceDefinition loadBalance() {
        LoadBalanceDefinition answer = new LoadBalanceDefinition();
        this.addOutput(answer);
        return answer;
    }

    public LoadBalanceDefinition loadBalance(LoadBalancer loadBalancer) {
        LoadBalanceDefinition answer = new LoadBalanceDefinition();
        this.addOutput(answer);
        return answer.loadBalance(loadBalancer);
    }

    public ChoiceDefinition choice() {
        ChoiceDefinition answer = new ChoiceDefinition();
        this.addOutput(answer);
        return answer;
    }

    public TryDefinition doTry() {
        TryDefinition answer = new TryDefinition();
        this.addOutput(answer);
        return answer;
    }

    public Type recipientList(Expression recipients) {
        RecipientListDefinition answer = new RecipientListDefinition(recipients);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type recipientList(Expression recipients, String delimiter) {
        RecipientListDefinition answer = new RecipientListDefinition(recipients);
        answer.setDelimiter(delimiter);
        this.addOutput(answer);
        return (Type)this;
    }

    public ExpressionClause<ProcessorDefinition<Type>> recipientList() {
        RecipientListDefinition answer = new RecipientListDefinition();
        this.addOutput(answer);
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        answer.setExpression(clause);
        return clause;
    }

    public Type routingSlip(String header, String uriDelimiter) {
        RoutingSlipDefinition answer = new RoutingSlipDefinition(header, uriDelimiter);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type routingSlip(String header) {
        RoutingSlipDefinition answer = new RoutingSlipDefinition(header);
        this.addOutput(answer);
        return (Type)this;
    }

    public SamplingDefinition sample() {
        return this.sample(1L, TimeUnit.SECONDS);
    }

    public SamplingDefinition sample(long samplePeriod, TimeUnit unit) {
        SamplingDefinition answer = new SamplingDefinition(samplePeriod, unit);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<SplitDefinition> split() {
        SplitDefinition answer = new SplitDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public SplitDefinition split(Expression expression) {
        SplitDefinition answer = new SplitDefinition(expression);
        this.addOutput(answer);
        return answer;
    }

    public SplitDefinition split(Expression expression, AggregationStrategy aggregationStrategy) {
        SplitDefinition answer = new SplitDefinition(expression);
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        return answer;
    }

    public ExpressionClause<ResequenceDefinition> resequence() {
        ResequenceDefinition answer = new ResequenceDefinition();
        this.addOutput(answer);
        ExpressionClause<ResequenceDefinition> clause = new ExpressionClause<ResequenceDefinition>(answer);
        answer.expression(clause);
        return clause;
    }

    public ResequenceDefinition resequence(Expression expression) {
        return this.resequence(Collections.singletonList(expression));
    }

    public ResequenceDefinition resequence(List<Expression> expressions) {
        ResequenceDefinition answer = new ResequenceDefinition(expressions);
        this.addOutput(answer);
        return answer;
    }

    public ResequenceDefinition resequencer(Expression ... expressions) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.addAll(Arrays.asList(expressions));
        return this.resequence(list);
    }

    public ExpressionClause<AggregateDefinition> aggregate() {
        AggregateDefinition answer = new AggregateDefinition();
        this.addOutput(answer);
        return answer.createAndSetExpression();
    }

    public ExpressionClause<AggregateDefinition> aggregate(AggregationStrategy aggregationStrategy) {
        AggregateDefinition answer = new AggregateDefinition();
        answer.setAggregationStrategy(aggregationStrategy);
        this.addOutput(answer);
        return answer.createAndSetExpression();
    }

    public AggregateDefinition aggregate(AggregationCollection aggregationCollection) {
        AggregateDefinition answer = new AggregateDefinition();
        answer.setAggregationCollection(aggregationCollection);
        this.addOutput(answer);
        return answer;
    }

    public AggregateDefinition aggregate(Expression correlationExpression) {
        AggregateDefinition answer = new AggregateDefinition(correlationExpression);
        this.addOutput(answer);
        return answer;
    }

    public AggregateDefinition aggregate(Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        AggregateDefinition answer = new AggregateDefinition(correlationExpression, aggregationStrategy);
        this.addOutput(answer);
        return answer;
    }

    public DelayDefinition delay(Expression delay) {
        DelayDefinition answer = new DelayDefinition(delay);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<DelayDefinition> delay() {
        DelayDefinition answer = new DelayDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public DelayDefinition delay(long delay) {
        return this.delay(ExpressionBuilder.constantExpression(delay));
    }

    public ThrottleDefinition throttle(long maximumRequestCount) {
        ThrottleDefinition answer = new ThrottleDefinition(maximumRequestCount);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<LoopDefinition> loop() {
        LoopDefinition loop = new LoopDefinition();
        this.addOutput(loop);
        return ExpressionClause.createAndSetExpression(loop);
    }

    public LoopDefinition loop(Expression expression) {
        LoopDefinition loop = this.getNodeFactory().createLoop();
        loop.setExpression(expression);
        this.addOutput(loop);
        return loop;
    }

    public LoopDefinition loop(int count) {
        LoopDefinition loop = this.getNodeFactory().createLoop();
        loop.setExpression(new ConstantExpression(Integer.toString(count)));
        this.addOutput(loop);
        return loop;
    }

    public Type throwException(Exception exception) {
        ThrowExceptionDefinition answer = new ThrowExceptionDefinition();
        answer.setException(exception);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type markRollbackOnly() {
        RollbackDefinition answer = new RollbackDefinition();
        answer.setMarkRollbackOnly(true);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type rollback() {
        return this.rollback(null);
    }

    public Type rollback(String message) {
        RollbackDefinition answer = new RollbackDefinition(message);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type wireTap(String uri) {
        WireTapDefinition answer = new WireTapDefinition();
        answer.setUri(uri);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type wireTap(String uri, Expression body) {
        WireTapDefinition answer = new WireTapDefinition();
        answer.setUri(uri);
        answer.setNewExchangeExpression(body);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type wireTap(String uri, Processor processor) {
        WireTapDefinition answer = new WireTapDefinition();
        answer.setUri(uri);
        answer.setNewExchangeProcessor(processor);
        this.addOutput(answer);
        return (Type)this;
    }

    void pushBlock(Block block) {
        this.blocks.add(block);
    }

    Block popBlock() {
        return this.blocks.isEmpty() ? null : this.blocks.removeLast();
    }

    public Type stop() {
        StopDefinition stop = new StopDefinition();
        this.addOutput(stop);
        return (Type)this;
    }

    public OnExceptionDefinition onException(Class exceptionType) {
        OnExceptionDefinition answer = new OnExceptionDefinition(exceptionType);
        this.addOutput(answer);
        return answer;
    }

    public PolicyDefinition policy(Policy policy) {
        PolicyDefinition answer = new PolicyDefinition(policy);
        this.addOutput(answer);
        return answer;
    }

    public PolicyDefinition policy(String ref) {
        PolicyDefinition answer = new PolicyDefinition();
        answer.setRef(ref);
        this.addOutput(answer);
        return answer;
    }

    public PolicyDefinition transacted() {
        PolicyDefinition answer = new PolicyDefinition();
        answer.setType(TransactedPolicy.class);
        this.addOutput(answer);
        return answer;
    }

    public PolicyDefinition transacted(String ref) {
        PolicyDefinition answer = new PolicyDefinition();
        answer.setType(TransactedPolicy.class);
        answer.setRef(ref);
        this.addOutput(answer);
        return answer;
    }

    public Type process(Processor processor) {
        ProcessDefinition answer = new ProcessDefinition(processor);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type processRef(String ref) {
        ProcessDefinition answer = new ProcessDefinition();
        answer.setRef(ref);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Object bean) {
        BeanDefinition answer = new BeanDefinition();
        answer.setBean(bean);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Object bean, String method) {
        BeanDefinition answer = new BeanDefinition();
        answer.setBean(bean);
        answer.setMethod(method);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Class beanType) {
        BeanDefinition answer = new BeanDefinition();
        answer.setBeanType(beanType);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Class beanType, String method) {
        BeanDefinition answer = new BeanDefinition();
        answer.setBeanType(beanType);
        answer.setMethod(method);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type beanRef(String ref) {
        BeanDefinition answer = new BeanDefinition(ref);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type beanRef(String ref, String method) {
        BeanDefinition answer = new BeanDefinition(ref, method);
        this.addOutput(answer);
        return (Type)this;
    }

    public ExpressionClause<ProcessorDefinition<Type>> setBody() {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        SetBodyDefinition answer = new SetBodyDefinition((Expression)clause);
        this.addOutput(answer);
        return clause;
    }

    public Type setBody(Expression expression) {
        SetBodyDefinition answer = new SetBodyDefinition(expression);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type transform(Expression expression) {
        TransformDefinition answer = new TransformDefinition(expression);
        this.addOutput(answer);
        return (Type)this;
    }

    public ExpressionClause<ProcessorDefinition<Type>> transform() {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        TransformDefinition answer = new TransformDefinition((Expression)clause);
        this.addOutput(answer);
        return clause;
    }

    public Type setFaultBody(Expression expression) {
        return this.process(ProcessorBuilder.setFaultBody(expression));
    }

    public ExpressionClause<ProcessorDefinition<Type>> setHeader(String name) {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        SetHeaderDefinition answer = new SetHeaderDefinition(name, clause);
        this.addOutput(answer);
        return clause;
    }

    public Type setHeader(String name, Expression expression) {
        SetHeaderDefinition answer = new SetHeaderDefinition(name, expression);
        this.addOutput(answer);
        return (Type)this;
    }

    public ExpressionClause<ProcessorDefinition<Type>> setOutHeader(String name) {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        SetOutHeaderDefinition answer = new SetOutHeaderDefinition(name, clause);
        this.addOutput(answer);
        return clause;
    }

    public Type setOutHeader(String name, Expression expression) {
        SetOutHeaderDefinition answer = new SetOutHeaderDefinition(name, expression);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type setFaultHeader(String name, Expression expression) {
        return this.process(ProcessorBuilder.setFaultHeader(name, expression));
    }

    public Type setProperty(String name, Expression expression) {
        SetPropertyDefinition answer = new SetPropertyDefinition(name, expression);
        this.addOutput(answer);
        return (Type)this;
    }

    public ExpressionClause<ProcessorDefinition<Type>> setProperty(String name) {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        SetPropertyDefinition answer = new SetPropertyDefinition(name, clause);
        this.addOutput(answer);
        return clause;
    }

    public Type removeHeader(String name) {
        RemoveHeaderDefinition answer = new RemoveHeaderDefinition(name);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type removeFaultHeader(String name) {
        return this.process(ProcessorBuilder.removeFaultHeader(name));
    }

    public Type removeProperty(String name) {
        RemovePropertyDefinition answer = new RemovePropertyDefinition(name);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type convertBodyTo(Class type) {
        this.addOutput(new ConvertBodyDefinition(type));
        return (Type)this;
    }

    public Type convertBodyTo(Class type, String charset) {
        this.addOutput(new ConvertBodyDefinition(type, charset));
        return (Type)this;
    }

    public Type sortBody(Comparator comparator) {
        this.addOutput(new SortDefinition(Builder.body(), comparator));
        return (Type)this;
    }

    public Type sortBody() {
        return this.sortBody(null);
    }

    public Type sort(Expression expression, Comparator comparator) {
        this.addOutput(new SortDefinition(expression, comparator));
        return (Type)this;
    }

    public Type sort(Expression expression) {
        return this.sort(expression, null);
    }

    public Type enrich(String resourceUri, AggregationStrategy aggregationStrategy) {
        this.addOutput(new EnrichDefinition(aggregationStrategy, resourceUri));
        return (Type)this;
    }

    public Type enrich(String resourceUri) {
        this.addOutput(new EnrichDefinition(resourceUri));
        return (Type)this;
    }

    public Type enrichRef(String resourceRef, String aggregationStrategyRef) {
        EnrichDefinition enrich = new EnrichDefinition();
        enrich.setResourceRef(resourceRef);
        enrich.setAggregationStrategyRef(aggregationStrategyRef);
        this.addOutput(enrich);
        return (Type)this;
    }

    public Type pollEnrich(String resourceUri) {
        this.addOutput(new PollEnrichDefinition(null, resourceUri, 0L));
        return (Type)this;
    }

    public Type pollEnrich(String resourceUri, AggregationStrategy aggregationStrategy) {
        this.addOutput(new PollEnrichDefinition(aggregationStrategy, resourceUri, 0L));
        return (Type)this;
    }

    public Type pollEnrich(String resourceUri, long timeout, AggregationStrategy aggregationStrategy) {
        this.addOutput(new PollEnrichDefinition(aggregationStrategy, resourceUri, timeout));
        return (Type)this;
    }

    public Type pollEnrich(String resourceUri, long timeout) {
        this.addOutput(new PollEnrichDefinition(null, resourceUri, timeout));
        return (Type)this;
    }

    public Type pollEnrichRef(String resourceRef, long timeout, String aggregationStrategyRef) {
        PollEnrichDefinition pollEnrich = new PollEnrichDefinition();
        pollEnrich.setResourceRef(resourceRef);
        pollEnrich.setTimeout(timeout);
        pollEnrich.setAggregationStrategyRef(aggregationStrategyRef);
        this.addOutput(pollEnrich);
        return (Type)this;
    }

    public OnCompletionDefinition onCompletion() {
        OnCompletionDefinition answer = new OnCompletionDefinition();
        answer.removeAllOnCompletionDefinition(this);
        this.popBlock();
        this.addOutput(answer);
        this.pushBlock(answer);
        return answer;
    }

    public DataFormatClause<ProcessorDefinition<Type>> unmarshal() {
        return new DataFormatClause<ProcessorDefinition<Type>>(this, DataFormatClause.Operation.Unmarshal);
    }

    public Type unmarshal(DataFormatDefinition dataFormatType) {
        this.addOutput(new UnmarshalDefinition(dataFormatType));
        return (Type)this;
    }

    public Type unmarshal(DataFormat dataFormat) {
        return this.unmarshal(new DataFormatDefinition(dataFormat));
    }

    public Type unmarshal(String dataTypeRef) {
        this.addOutput(new UnmarshalDefinition(dataTypeRef));
        return (Type)this;
    }

    public DataFormatClause<ProcessorDefinition<Type>> marshal() {
        return new DataFormatClause<ProcessorDefinition<Type>>(this, DataFormatClause.Operation.Marshal);
    }

    public Type marshal(DataFormatDefinition dataFormatType) {
        this.addOutput(new MarshalDefinition(dataFormatType));
        return (Type)this;
    }

    public Type marshal(DataFormat dataFormat) {
        return this.marshal(new DataFormatDefinition(dataFormat));
    }

    public Type marshal(String dataTypeRef) {
        this.addOutput(new MarshalDefinition(dataTypeRef));
        return (Type)this;
    }

    @XmlTransient
    public ProcessorDefinition getParent() {
        return this.parent;
    }

    public void setParent(ProcessorDefinition parent) {
        this.parent = parent;
    }

    @XmlTransient
    public ErrorHandlerBuilder getErrorHandlerBuilder() {
        if (this.errorHandlerBuilder == null) {
            this.errorHandlerBuilder = this.createErrorHandlerBuilder();
        }
        return this.errorHandlerBuilder;
    }

    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        this.errorHandlerBuilder = errorHandlerBuilder;
    }

    @XmlTransient
    public NodeFactory getNodeFactory() {
        if (this.nodeFactory == null) {
            this.nodeFactory = new NodeFactory();
        }
        return this.nodeFactory;
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    @XmlTransient
    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void addInterceptStrategy(InterceptStrategy strategy) {
        this.interceptStrategies.add(strategy);
    }

    public String getLabel() {
        return "";
    }
}

