/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SedaComponent
extends DefaultComponent {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected final int maxConcurrentConsumers = 500;
    protected int queueSize;
    protected int defaultConcurrentConsumers = 1;
    private final Map<String, QueueReference> queues = new HashMap<String, QueueReference>();

    public void setQueueSize(int size) {
        this.queueSize = size;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setConcurrentConsumers(int size) {
        this.defaultConcurrentConsumers = size;
    }

    public int getConcurrentConsumers() {
        return this.defaultConcurrentConsumers;
    }

    public synchronized QueueReference getOrCreateQueue(String uri, Integer size) {
        LinkedBlockingQueue queue;
        String key = this.getQueueKey(uri);
        QueueReference ref = this.getQueues().get(key);
        if (ref != null) {
            if (size != null && ref.getSize() != size) {
                throw new IllegalArgumentException("Cannot use existing queue " + key + " as the existing queue size " + (ref.getSize() != null ? ref.getSize() : Integer.MAX_VALUE) + " does not match given queue size " + size);
            }
            ref.addReference();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Reusing existing queue {} with size {} and reference count {}", new Object[]{key, size, ref.getCount()});
            }
            return ref;
        }
        if (size != null && size > 0) {
            queue = new LinkedBlockingQueue(size);
        } else if (this.getQueueSize() > 0) {
            size = this.getQueueSize();
            queue = new LinkedBlockingQueue(this.getQueueSize());
        } else {
            queue = new LinkedBlockingQueue();
        }
        this.log.debug("Created queue {} with size {}", (Object)key, (Object)size);
        ref = new QueueReference(queue, size);
        ref.addReference();
        this.getQueues().put(key, ref);
        return ref;
    }

    public Map<String, QueueReference> getQueues() {
        return this.queues;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        int consumers = this.getAndRemoveParameter(parameters, "concurrentConsumers", Integer.class, this.defaultConcurrentConsumers);
        boolean limitConcurrentConsumers = this.getAndRemoveParameter(parameters, "limitConcurrentConsumers", Boolean.class, true);
        if (limitConcurrentConsumers && consumers > 500) {
            throw new IllegalArgumentException("The limitConcurrentConsumers flag in set to true. ConcurrentConsumers cannot be set at a value greater than 500 was " + consumers);
        }
        SedaEndpoint answer = new SedaEndpoint(uri, this, null, consumers);
        answer.configureProperties(parameters);
        return answer;
    }

    public String getQueueKey(String uri) {
        if (uri.contains("?")) {
            uri = uri.substring(0, uri.indexOf(63));
        }
        return uri;
    }

    @Override
    protected void doStop() throws Exception {
        this.getQueues().clear();
        super.doStop();
    }

    void onShutdownEndpoint(SedaEndpoint endpoint) {
        String key = this.getQueueKey(endpoint.getEndpointUri());
        QueueReference ref = this.getQueues().get(key);
        if (ref != null) {
            ref.removeReference();
            if (ref.getCount() <= 0) {
                this.getQueues().remove(key);
            }
        }
    }

    public static final class QueueReference {
        private final BlockingQueue<Exchange> queue;
        private volatile int count;
        private Integer size;

        private QueueReference(BlockingQueue<Exchange> queue, Integer size) {
            this.queue = queue;
            this.size = size;
        }

        void addReference() {
            ++this.count;
        }

        void removeReference() {
            --this.count;
        }

        public int getCount() {
            return this.count;
        }

        public Integer getSize() {
            return this.size;
        }

        public BlockingQueue<Exchange> getQueue() {
            return this.queue;
        }
    }
}

