/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedNotification;
import org.apache.camel.api.management.ManagedNotifications;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.LRUWeakCache;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanInfoAssembler
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanInfoAssembler.class);
    private final LRUCache<Class<?>, MBeanAttributesAndOperations> cache = new LRUWeakCache(1000);

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing cache[size={}, hits={}, misses={}, evicted={}]", new Object[]{this.cache.size(), this.cache.getHits(), this.cache.getMisses(), this.cache.getEvicted()});
        }
        this.cache.clear();
    }

    public ModelMBeanInfo getMBeanInfo(Object defaultManagedBean, Object customManagedBean, String objectName) throws JMException {
        if (Proxy.isProxyClass(defaultManagedBean.getClass())) {
            LOG.trace("Skip creating ModelMBeanInfo due proxy class {}", defaultManagedBean.getClass());
            return null;
        }
        LinkedHashMap<String, ManagedAttributeInfo> attributes = new LinkedHashMap<String, ManagedAttributeInfo>();
        LinkedHashSet<ManagedOperationInfo> operations = new LinkedHashSet<ManagedOperationInfo>();
        LinkedHashSet<ModelMBeanAttributeInfo> mBeanAttributes = new LinkedHashSet<ModelMBeanAttributeInfo>();
        LinkedHashSet<ModelMBeanOperationInfo> mBeanOperations = new LinkedHashSet<ModelMBeanOperationInfo>();
        LinkedHashSet<ModelMBeanNotificationInfo> mBeanNotifications = new LinkedHashSet<ModelMBeanNotificationInfo>();
        this.extractAttributesAndOperations(defaultManagedBean.getClass(), attributes, operations);
        this.extractMbeanAttributes(defaultManagedBean, attributes, mBeanAttributes, mBeanOperations);
        this.extractMbeanOperations(defaultManagedBean, operations, mBeanOperations);
        this.extractMbeanNotifications(defaultManagedBean, mBeanNotifications);
        if (customManagedBean != null) {
            this.extractAttributesAndOperations(customManagedBean.getClass(), attributes, operations);
            this.extractMbeanAttributes(customManagedBean, attributes, mBeanAttributes, mBeanOperations);
            this.extractMbeanOperations(customManagedBean, operations, mBeanOperations);
            this.extractMbeanNotifications(customManagedBean, mBeanNotifications);
        }
        String name = this.getName(customManagedBean != null ? customManagedBean : defaultManagedBean, objectName);
        String description = this.getDescription(customManagedBean != null ? customManagedBean : defaultManagedBean, objectName);
        ModelMBeanAttributeInfo[] arrayAttributes = mBeanAttributes.toArray(new ModelMBeanAttributeInfo[mBeanAttributes.size()]);
        ModelMBeanOperationInfo[] arrayOperations = mBeanOperations.toArray(new ModelMBeanOperationInfo[mBeanOperations.size()]);
        ModelMBeanNotificationInfo[] arrayNotifications = mBeanNotifications.toArray(new ModelMBeanNotificationInfo[mBeanNotifications.size()]);
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(name, description, arrayAttributes, null, arrayOperations, arrayNotifications);
        LOG.trace("Created ModelMBeanInfo {}", (Object)info);
        return info;
    }

    private void extractAttributesAndOperations(Class<?> managedClass, Map<String, ManagedAttributeInfo> attributes, Set<ManagedOperationInfo> operations) {
        MBeanAttributesAndOperations cached = this.cache.get(managedClass);
        if (cached == null) {
            this.doExtractAttributesAndOperations(managedClass, attributes, operations);
            cached = new MBeanAttributesAndOperations();
            cached.attributes = new LinkedHashMap<String, ManagedAttributeInfo>(attributes);
            cached.operations = new LinkedHashSet<ManagedOperationInfo>(operations);
            attributes.clear();
            operations.clear();
            this.cache.put(managedClass, cached);
        }
        attributes.putAll(cached.attributes);
        operations.addAll(cached.operations);
    }

    private void doExtractAttributesAndOperations(Class<?> managedClass, Map<String, ManagedAttributeInfo> attributes, Set<ManagedOperationInfo> operations) {
        Class<?> clazz;
        this.doDoExtractAttributesAndOperations(managedClass, attributes, operations);
        if (managedClass.getSuperclass() != null && !(clazz = managedClass.getSuperclass()).getName().startsWith("java")) {
            LOG.trace("Extracting attributes and operations from sub class: {}", clazz);
            this.doExtractAttributesAndOperations(clazz, attributes, operations);
        }
        if (managedClass.getInterfaces() != null) {
            for (Class<?> clazz2 : managedClass.getInterfaces()) {
                if (clazz2.getName().startsWith("java")) continue;
                LOG.trace("Extracting attributes and operations from implemented interface: {}", clazz2);
                this.doExtractAttributesAndOperations(clazz2, attributes, operations);
            }
        }
    }

    private void doDoExtractAttributesAndOperations(Class<?> managedClass, Map<String, ManagedAttributeInfo> attributes, Set<ManagedOperationInfo> operations) {
        LOG.trace("Extracting attributes and operations from class: {}", managedClass);
        IntrospectionSupport.ClassInfo cache = IntrospectionSupport.cacheClass(managedClass);
        for (IntrospectionSupport.MethodInfo cacheInfo : cache.methods) {
            ManagedOperation mo;
            String desc;
            if (cacheInfo.method.getDeclaringClass() != managedClass) continue;
            LOG.trace("Extracting attributes and operations from method: {}", (Object)cacheInfo.method);
            ManagedAttribute ma = cacheInfo.method.getAnnotation(ManagedAttribute.class);
            if (ma != null) {
                String key;
                desc = ma.description();
                Method getter = null;
                Method setter = null;
                if (cacheInfo.isGetter.booleanValue()) {
                    key = cacheInfo.getterOrSetterShorthandName;
                    getter = cacheInfo.method;
                } else if (cacheInfo.isSetter.booleanValue()) {
                    key = cacheInfo.getterOrSetterShorthandName;
                    setter = cacheInfo.method;
                } else {
                    throw new IllegalArgumentException("@ManagedAttribute can only be used on Java bean methods, was: " + cacheInfo.method + " on bean: " + managedClass);
                }
                key = ObjectHelper.capitalize(key);
                ManagedAttributeInfo info = attributes.get(key);
                if (info == null) {
                    info = new ManagedAttributeInfo(key, desc);
                }
                if (getter != null) {
                    info.setGetter(getter);
                }
                if (setter != null) {
                    info.setSetter(setter);
                }
                attributes.put(key, info);
            }
            if ((mo = cacheInfo.method.getAnnotation(ManagedOperation.class)) == null) continue;
            desc = mo.description();
            Method operation = cacheInfo.method;
            operations.add(new ManagedOperationInfo(desc, operation));
        }
    }

    private void extractMbeanAttributes(Object managedBean, Map<String, ManagedAttributeInfo> attributes, Set<ModelMBeanAttributeInfo> mBeanAttributes, Set<ModelMBeanOperationInfo> mBeanOperations) throws IntrospectionException {
        for (ManagedAttributeInfo info : attributes.values()) {
            ModelMBeanOperationInfo mbeanOperation;
            ModelMBeanAttributeInfo mbeanAttribute = new ModelMBeanAttributeInfo(info.getKey(), info.getDescription(), info.getGetter(), info.getSetter());
            Descriptor desc = mbeanAttribute.getDescriptor();
            if (info.getGetter() != null) {
                desc.setField("getMethod", info.getGetter().getName());
                mbeanOperation = new ModelMBeanOperationInfo(info.getKey(), info.getGetter());
                mBeanOperations.add(mbeanOperation);
            }
            if (info.getSetter() != null) {
                desc.setField("setMethod", info.getSetter().getName());
                mbeanOperation = new ModelMBeanOperationInfo(info.getKey(), info.getSetter());
                mBeanOperations.add(mbeanOperation);
            }
            mbeanAttribute.setDescriptor(desc);
            mBeanAttributes.add(mbeanAttribute);
            LOG.trace("Assembled attribute: {}", (Object)mbeanAttribute);
        }
    }

    private void extractMbeanOperations(Object managedBean, Set<ManagedOperationInfo> operations, Set<ModelMBeanOperationInfo> mBeanOperations) {
        for (ManagedOperationInfo info : operations) {
            ModelMBeanOperationInfo mbean = new ModelMBeanOperationInfo(info.getDescription(), info.getOperation());
            mBeanOperations.add(mbean);
            LOG.trace("Assembled operation: {}", (Object)mbean);
        }
    }

    private void extractMbeanNotifications(Object managedBean, Set<ModelMBeanNotificationInfo> mBeanNotifications) {
        ManagedNotifications notifications = managedBean.getClass().getAnnotation(ManagedNotifications.class);
        if (notifications != null) {
            for (ManagedNotification notification : notifications.value()) {
                ModelMBeanNotificationInfo info = new ModelMBeanNotificationInfo(notification.notificationTypes(), notification.name(), notification.description());
                mBeanNotifications.add(info);
                LOG.trace("Assembled notification: {}", (Object)info);
            }
        }
    }

    private String getDescription(Object managedBean, String objectName) {
        ManagedResource mr = ObjectHelper.getAnnotation(managedBean, ManagedResource.class);
        return mr != null ? mr.description() : "";
    }

    private String getName(Object managedBean, String objectName) {
        return managedBean.getClass().getName();
    }

    private static final class ManagedOperationInfo {
        private final String description;
        private final Method operation;

        private ManagedOperationInfo(String description, Method operation) {
            this.description = description;
            this.operation = operation;
        }

        public String getDescription() {
            return this.description;
        }

        public Method getOperation() {
            return this.operation;
        }

        public String toString() {
            return "ManagedOperationInfo: [" + this.operation + "]";
        }
    }

    private static final class ManagedAttributeInfo {
        private String key;
        private String description;
        private Method getter;
        private Method setter;

        private ManagedAttributeInfo(String key, String description) {
            this.key = key;
            this.description = description;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public Method getGetter() {
            return this.getter;
        }

        public void setGetter(Method getter) {
            this.getter = getter;
        }

        public Method getSetter() {
            return this.setter;
        }

        public void setSetter(Method setter) {
            this.setter = setter;
        }

        public String toString() {
            return "ManagedAttributeInfo: [" + this.key + " + getter: " + this.getter + ", setter: " + this.setter + "]";
        }
    }

    private static final class MBeanAttributesAndOperations {
        private Map<String, ManagedAttributeInfo> attributes;
        private Set<ManagedOperationInfo> operations;

        private MBeanAttributesAndOperations() {
        }
    }
}

