/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.processor.aggregate.CompletionAwareAggregationStrategy;

public abstract class AbstractListAggregationStrategy<V>
implements CompletionAwareAggregationStrategy {
    public abstract V getValue(Exchange var1);

    public boolean isStoreAsBodyOnCompletion() {
        return true;
    }

    @Override
    public void onCompletion(Exchange exchange) {
        List list;
        if (this.isStoreAsBodyOnCompletion() && (list = (List)exchange.removeProperty("CamelGroupedExchange")) != null) {
            exchange.getIn().setBody(list);
        }
    }

    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        V value;
        List<V> list;
        Exchange answer = oldExchange;
        if (oldExchange == null) {
            answer = new DefaultExchange(newExchange);
            list = this.getList(answer);
        } else {
            list = this.getList(oldExchange);
        }
        if (newExchange != null && (value = this.getValue(newExchange)) != null) {
            list.add(value);
        }
        return answer;
    }

    private List<V> getList(Exchange exchange) {
        ArrayList list = exchange.getProperty("CamelGroupedExchange", List.class);
        if (list == null) {
            list = new ArrayList();
            exchange.setProperty("CamelGroupedExchange", list);
        }
        return list;
    }
}

