/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.NotificationSenderAware;
import org.apache.camel.management.MBeanInfoAssembler;
import org.apache.camel.management.NotificationSenderAdapter;
import org.apache.camel.spi.ManagementMBeanAssembler;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManagementMBeanAssembler
implements ManagementMBeanAssembler,
Service {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MBeanInfoAssembler assembler = new MBeanInfoAssembler();

    @Override
    public ModelMBean assemble(MBeanServer mBeanServer, Object obj, ObjectName name) throws JMException {
        Object custom;
        ModelMBeanInfo mbi = null;
        if (obj instanceof ManagedInstance && (custom = ((ManagedInstance)obj).getInstance()) != null && ObjectHelper.hasAnnotation(custom.getClass().getAnnotations(), ManagedResource.class)) {
            this.log.trace("Assembling MBeanInfo for: {} from custom @ManagedResource object: {}", (Object)name, custom);
            mbi = this.assembler.getMBeanInfo(null, custom, name.toString());
            obj = custom;
        }
        if (mbi == null) {
            this.log.trace("Assembling MBeanInfo for: {} from @ManagedResource object: {}", (Object)name, obj);
            mbi = this.assembler.getMBeanInfo(obj, null, name.toString());
        }
        if (mbi == null) {
            return null;
        }
        RequiredModelMBean mbean = (RequiredModelMBean)mBeanServer.instantiate(RequiredModelMBean.class.getName());
        mbean.setModelMBeanInfo(mbi);
        try {
            mbean.setManagedResource(obj, "ObjectReference");
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new JMException(e.getMessage());
        }
        if (obj instanceof NotificationSenderAware) {
            ((NotificationSenderAware)obj).setNotificationSender(new NotificationSenderAdapter(mbean));
        }
        return mbean;
    }

    @Override
    public void start() throws Exception {
        ServiceHelper.startService(this.assembler);
    }

    @Override
    public void stop() throws Exception {
        ServiceHelper.stopService(this.assembler);
    }
}

