/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;

public final class RouteDefinitionHelper {
    private RouteDefinitionHelper() {
    }

    public static void forceAssignIds(CamelContext context, List<RouteDefinition> routes) throws Exception {
        for (RouteDefinition route : routes) {
            route.idOrCreate(context.getNodeIdFactory());
            if (!route.hasCustomIdAssigned()) continue;
            String id = route.getId();
            route.setId(context.resolvePropertyPlaceholders(id));
        }
    }

    public static String validateUniqueIds(RouteDefinition target, List<RouteDefinition> routes) {
        LinkedHashSet<String> routesIds = new LinkedHashSet<String>();
        for (RouteDefinition route : routes) {
            if (route == target) continue;
            ProcessorDefinitionHelper.gatherAllNodeIds(route, routesIds, true, false);
        }
        LinkedHashSet<String> targetIds = new LinkedHashSet<String>();
        ProcessorDefinitionHelper.gatherAllNodeIds(target, targetIds, true, false);
        for (String id : targetIds) {
            if (!routesIds.contains(id)) continue;
            return id;
        }
        return null;
    }

    public static void initParent(ProcessorDefinition parent) {
        List<ProcessorDefinition<?>> children = parent.getOutputs();
        for (ProcessorDefinition<?> child : children) {
            child.setParent(parent);
            if (child.getOutputs() == null || child.getOutputs().isEmpty()) continue;
            RouteDefinitionHelper.initParent(child);
        }
    }

    private static void initParentAndErrorHandlerBuilder(ProcessorDefinition parent) {
        List<ProcessorDefinition<?>> children = parent.getOutputs();
        for (ProcessorDefinition<?> child : children) {
            child.setParent(parent);
            if (child.getOutputs() == null || child.getOutputs().isEmpty()) continue;
            RouteDefinitionHelper.initParentAndErrorHandlerBuilder(child);
        }
    }

    public static void prepareRouteForInit(RouteDefinition route, List<ProcessorDefinition<?>> abstracts, List<ProcessorDefinition<?>> lower) {
        for (ProcessorDefinition<?> output : route.getOutputs()) {
            if (output.isAbstract()) {
                abstracts.add(output);
                continue;
            }
            lower.add(output);
        }
    }

    public static void prepareRoute(ModelCamelContext context, RouteDefinition route) {
        RouteDefinitionHelper.prepareRoute(context, route, null, null, null, null, null);
    }

    public static void prepareRoute(ModelCamelContext context, RouteDefinition route, List<OnExceptionDefinition> onExceptions, List<InterceptDefinition> intercepts, List<InterceptFromDefinition> interceptFromDefinitions, List<InterceptSendToEndpointDefinition> interceptSendToEndpointDefinitions, List<OnCompletionDefinition> onCompletions) {
        ArrayList abstracts = new ArrayList();
        ArrayList upper = new ArrayList();
        ArrayList lower = new ArrayList();
        RouteDefinitionHelper.prepareRouteForInit(route, abstracts, lower);
        RouteDefinitionHelper.initParentAndErrorHandlerBuilder(context, route, abstracts, onExceptions);
        RouteDefinitionHelper.initInterceptors(context, route, abstracts, upper, intercepts, interceptFromDefinitions, interceptSendToEndpointDefinitions);
        RouteDefinitionHelper.initOnCompletions(abstracts, upper, onCompletions);
        RouteDefinitionHelper.initTransacted(abstracts, lower);
        RouteDefinitionHelper.initOnExceptions(abstracts, upper, onExceptions);
        route.clearOutput();
        route.getOutputs().addAll(lower);
        route.getOutputs().addAll(0, upper);
    }

    public static void sanityCheckRoute(RouteDefinition route) {
        ObjectHelper.notNull(route, "route");
        if (route.getInputs() == null || route.getInputs().isEmpty()) {
            String msg = "Route has no inputs: " + route;
            if (route.getId() != null) {
                msg = "Route " + route.getId() + " has no inputs: " + route;
            }
            throw new IllegalArgumentException(msg);
        }
        if (route.getOutputs() == null || route.getOutputs().isEmpty()) {
            String msg = "Route has no outputs: " + route;
            if (route.getId() != null) {
                msg = "Route " + route.getId() + " has no outputs: " + route;
            }
            throw new IllegalArgumentException(msg);
        }
    }

    private static void initParentAndErrorHandlerBuilder(ModelCamelContext context, RouteDefinition route, List<ProcessorDefinition<?>> abstracts, List<OnExceptionDefinition> onExceptions) {
        ErrorHandlerBuilder builder;
        if (context != null && (builder = context.getErrorHandlerBuilder()) != null) {
            builder = builder.cloneBuilder();
            route.setErrorHandlerBuilderIfNull(builder);
        }
        RouteDefinitionHelper.initParentAndErrorHandlerBuilder(route);
        if (onExceptions != null) {
            for (OnExceptionDefinition global : onExceptions) {
                RouteDefinitionHelper.initParentAndErrorHandlerBuilder(global);
            }
        }
    }

    private static void initOnExceptions(List<ProcessorDefinition<?>> abstracts, List<ProcessorDefinition<?>> upper, List<OnExceptionDefinition> onExceptions) {
        if (onExceptions != null && !onExceptions.isEmpty()) {
            for (OnExceptionDefinition onExceptionDefinition : onExceptions) {
                onExceptionDefinition.setRouteScoped(false);
                abstracts.add(onExceptionDefinition);
            }
        }
        for (ProcessorDefinition<?> processorDefinition : abstracts) {
            if (!(processorDefinition instanceof OnExceptionDefinition)) continue;
            int index = 0;
            for (int i = 0; i < upper.size(); ++i) {
                ProcessorDefinition<?> up = upper.get(i);
                if (!(up instanceof OnExceptionDefinition)) {
                    index = i;
                    break;
                }
                ++index;
            }
            upper.add(index, processorDefinition);
        }
    }

    private static void initInterceptors(CamelContext context, RouteDefinition route, List<ProcessorDefinition<?>> abstracts, List<ProcessorDefinition<?>> upper, List<InterceptDefinition> intercepts, List<InterceptFromDefinition> interceptFromDefinitions, List<InterceptSendToEndpointDefinition> interceptSendToEndpointDefinitions) {
        for (ProcessorDefinition<?> processor : abstracts) {
            if (processor instanceof InterceptSendToEndpointDefinition) {
                if (interceptSendToEndpointDefinitions == null) {
                    interceptSendToEndpointDefinitions = new ArrayList<InterceptSendToEndpointDefinition>();
                }
                interceptSendToEndpointDefinitions.add((InterceptSendToEndpointDefinition)processor);
                continue;
            }
            if (processor instanceof InterceptFromDefinition) {
                if (interceptFromDefinitions == null) {
                    interceptFromDefinitions = new ArrayList<InterceptFromDefinition>();
                }
                interceptFromDefinitions.add((InterceptFromDefinition)processor);
                continue;
            }
            if (!(processor instanceof InterceptDefinition)) continue;
            if (intercepts == null) {
                intercepts = new ArrayList<InterceptDefinition>();
            }
            intercepts.add((InterceptDefinition)processor);
        }
        RouteDefinitionHelper.doInitInterceptors(context, route, upper, intercepts, interceptFromDefinitions, interceptSendToEndpointDefinitions);
    }

    private static void doInitInterceptors(CamelContext context, RouteDefinition route, List<ProcessorDefinition<?>> upper, List<InterceptDefinition> intercepts, List<InterceptFromDefinition> interceptFromDefinitions, List<InterceptSendToEndpointDefinition> interceptSendToEndpointDefinitions) {
        if (intercepts != null && !intercepts.isEmpty()) {
            for (InterceptDefinition interceptDefinition : intercepts) {
                interceptDefinition.afterPropertiesSet();
                RouteDefinitionHelper.initParent(interceptDefinition);
                upper.add(0, interceptDefinition);
            }
        }
        if (interceptFromDefinitions != null && !interceptFromDefinitions.isEmpty()) {
            for (InterceptFromDefinition interceptFromDefinition : interceptFromDefinitions) {
                boolean match = true;
                if (interceptFromDefinition.getUri() != null) {
                    String pattern;
                    try {
                        pattern = context.resolvePropertyPlaceholders(interceptFromDefinition.getUri());
                    }
                    catch (Exception e) {
                        throw ObjectHelper.wrapRuntimeCamelException(e);
                    }
                    match = false;
                    for (FromDefinition input : route.getInputs()) {
                        String uri = input.getUri();
                        if (uri != null && uri.startsWith("ref:")) {
                            uri = CamelContextHelper.getMandatoryEndpoint(context, uri).getEndpointUri();
                        } else if (input.getRef() != null) {
                            uri = CamelContextHelper.getMandatoryEndpoint(context, "ref:" + input.getRef()).getEndpointUri();
                        }
                        if (!EndpointHelper.matchEndpoint(context, uri, pattern)) continue;
                        match = true;
                        break;
                    }
                }
                if (!match) continue;
                interceptFromDefinition.afterPropertiesSet();
                RouteDefinitionHelper.initParent(interceptFromDefinition);
                upper.add(0, interceptFromDefinition);
            }
        }
        if (interceptSendToEndpointDefinitions != null && !interceptSendToEndpointDefinitions.isEmpty()) {
            for (InterceptSendToEndpointDefinition interceptSendToEndpointDefinition : interceptSendToEndpointDefinitions) {
                interceptSendToEndpointDefinition.afterPropertiesSet();
                RouteDefinitionHelper.initParent(interceptSendToEndpointDefinition);
                upper.add(0, interceptSendToEndpointDefinition);
            }
        }
    }

    private static void initOnCompletions(List<ProcessorDefinition<?>> abstracts, List<ProcessorDefinition<?>> upper, List<OnCompletionDefinition> onCompletions) {
        List<Object> completions = new ArrayList();
        for (ProcessorDefinition<?> processorDefinition : abstracts) {
            if (!(processorDefinition instanceof OnCompletionDefinition)) continue;
            completions.add((OnCompletionDefinition)processorDefinition);
        }
        if (completions.isEmpty() && onCompletions != null) {
            completions = onCompletions;
            for (OnCompletionDefinition onCompletionDefinition : completions) {
                RouteDefinitionHelper.initParent(onCompletionDefinition);
            }
        }
        if (completions.isEmpty()) {
            return;
        }
        upper.addAll(completions);
    }

    private static void initTransacted(List<ProcessorDefinition<?>> abstracts, List<ProcessorDefinition<?>> lower) {
        OutputDefinition transacted = null;
        for (ProcessorDefinition<?> type : abstracts) {
            if (!(type instanceof TransactedDefinition)) continue;
            if (transacted == null) {
                transacted = (TransactedDefinition)type;
                continue;
            }
            throw new IllegalArgumentException("The route can only have one transacted defined");
        }
        if (transacted != null) {
            transacted.getOutputs().addAll(lower);
            lower.clear();
            lower.add(transacted);
        }
    }

    public static void forceAssignIds(CamelContext context, ProcessorDefinition processor) {
        List<ProcessorDefinition<?>> children;
        processor.idOrCreate(context.getNodeIdFactory());
        if (processor.hasCustomIdAssigned()) {
            String id = processor.getId();
            try {
                processor.setId(context.resolvePropertyPlaceholders(id));
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        if ((children = processor.getOutputs()) != null && !children.isEmpty()) {
            for (ProcessorDefinition<?> child : children) {
                RouteDefinitionHelper.forceAssignIds(context, child);
            }
        }
    }
}

