/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Ordered;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnCompletionProcessor
extends ServiceSupport
implements Processor,
Traceable {
    private static final transient Logger LOG = LoggerFactory.getLogger(OnCompletionProcessor.class);
    private final CamelContext camelContext;
    private final Processor processor;
    private final ExecutorService executorService;
    private final boolean shutdownExecutorService;
    private final boolean onCompleteOnly;
    private final boolean onFailureOnly;
    private final Predicate onWhen;
    private final boolean useOriginalBody;

    public OnCompletionProcessor(CamelContext camelContext, Processor processor, ExecutorService executorService, boolean shutdownExecutorService, boolean onCompleteOnly, boolean onFailureOnly, Predicate onWhen, boolean useOriginalBody) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(processor, "processor");
        this.camelContext = camelContext;
        this.processor = processor;
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
        this.onCompleteOnly = onCompleteOnly;
        this.onFailureOnly = onFailureOnly;
        this.onWhen = onWhen;
        this.useOriginalBody = useOriginalBody;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.processor);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.processor);
        if (this.shutdownExecutorService) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.processor == null) {
            return;
        }
        exchange.getUnitOfWork().addSynchronization(new OnCompletionSynchronization());
    }

    protected static void doProcess(Processor processor, Exchange exchange) {
        try {
            processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
    }

    protected Exchange prepareExchange(Exchange exchange) {
        Exchange answer = ExchangeHelper.createCorrelatedCopy(exchange, false);
        if (answer.hasOut()) {
            answer.setIn(answer.getOut());
            answer.setOut(null);
        }
        answer.setPattern(ExchangePattern.InOnly);
        if (this.useOriginalBody) {
            LOG.trace("Using the original IN message instead of current");
            Message original = exchange.getUnitOfWork().getOriginalInMessage();
            answer.setIn(original);
        }
        answer.setProperty("CamelOnCompletion", Boolean.TRUE);
        return answer;
    }

    public String toString() {
        return "OnCompletionProcessor[" + this.processor + "]";
    }

    @Override
    public String getTraceLabel() {
        return "onCompletion";
    }

    private final class OnCompletionSynchronization
    extends SynchronizationAdapter
    implements Ordered {
        private OnCompletionSynchronization() {
        }

        @Override
        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void onComplete(Exchange exchange) {
            if (OnCompletionProcessor.this.onFailureOnly) {
                return;
            }
            if (OnCompletionProcessor.this.onWhen != null && !OnCompletionProcessor.this.onWhen.matches(exchange)) {
                return;
            }
            final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange);
            OnCompletionProcessor.this.executorService.submit(new Callable<Exchange>(){

                @Override
                public Exchange call() throws Exception {
                    LOG.debug("Processing onComplete: {}", (Object)copy);
                    OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                    return copy;
                }
            });
        }

        @Override
        public void onFailure(Exchange exchange) {
            if (OnCompletionProcessor.this.onCompleteOnly) {
                return;
            }
            if (OnCompletionProcessor.this.onWhen != null && !OnCompletionProcessor.this.onWhen.matches(exchange)) {
                return;
            }
            final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange);
            copy.setException(null);
            OnCompletionProcessor.this.executorService.submit(new Callable<Exchange>(){

                @Override
                public Exchange call() throws Exception {
                    LOG.debug("Processing onFailure: {}", (Object)copy);
                    OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                    return null;
                }
            });
        }

        public String toString() {
            if (!OnCompletionProcessor.this.onCompleteOnly && !OnCompletionProcessor.this.onFailureOnly) {
                return "onCompleteOrFailure";
            }
            if (OnCompletionProcessor.this.onCompleteOnly) {
                return "onCompleteOnly";
            }
            return "onFailureOnly";
        }
    }
}

