/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.Date;
import java.util.Queue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.camel.processor.interceptor.DefaultBacklogTracerEventMessage;
import org.apache.camel.util.MessageHelper;

public class BacklogTracerInterceptor
extends DelegateAsyncProcessor {
    private final Queue<DefaultBacklogTracerEventMessage> queue;
    private final BacklogTracer backlogTracer;
    private final ProcessorDefinition<?> processorDefinition;
    private final ProcessorDefinition<?> routeDefinition;
    private final boolean first;

    public BacklogTracerInterceptor(Queue<DefaultBacklogTracerEventMessage> queue, Processor processor, ProcessorDefinition<?> processorDefinition, ProcessorDefinition<?> routeDefinition, boolean first, BacklogTracer tracer) {
        super(processor);
        this.queue = queue;
        this.processorDefinition = processorDefinition;
        this.routeDefinition = routeDefinition;
        this.first = first;
        this.backlogTracer = tracer;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            if (this.backlogTracer.shouldTrace(this.processorDefinition, exchange)) {
                int drain = this.queue.size() - this.backlogTracer.getBacklogSize();
                if ((drain += this.first ? 2 : 1) > 0) {
                    for (int i = 0; i < drain; ++i) {
                        this.queue.poll();
                    }
                }
                Date timestamp = new Date();
                String toNode = this.processorDefinition.getId();
                String exchangeId = exchange.getExchangeId();
                String messageAsXml = MessageHelper.dumpAsXml(exchange.getIn(), true, 4, this.backlogTracer.isBodyIncludeStreams(), this.backlogTracer.isBodyIncludeFiles(), this.backlogTracer.getBodyMaxChars());
                String routeId = this.routeDefinition.getId();
                if (this.first) {
                    Date created = exchange.getProperty("CamelCreatedTimestamp", timestamp, Date.class);
                    DefaultBacklogTracerEventMessage pseudo = new DefaultBacklogTracerEventMessage(this.backlogTracer.incrementTraceCounter(), created, routeId, null, exchangeId, messageAsXml);
                    this.queue.add(pseudo);
                }
                DefaultBacklogTracerEventMessage event = new DefaultBacklogTracerEventMessage(this.backlogTracer.incrementTraceCounter(), timestamp, routeId, toNode, exchangeId, messageAsXml);
                this.queue.add(event);
            }
            return super.process(exchange, callback);
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        this.queue.clear();
        this.backlogTracer.stopProcessor(this.processorDefinition);
    }

    @Override
    public String toString() {
        return this.processor.toString();
    }
}

