/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.component.log.LogEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.processor.CamelLogProcessor;
import org.apache.camel.processor.DefaultExchangeFormatter;
import org.apache.camel.processor.ThroughputLogger;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.util.CamelLogger;

public class LogComponent
extends DefaultComponent {
    private ExchangeFormatter exchangeFormatter;

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        AsyncProcessor logger;
        HashMap<String, Object> originalParameters = new HashMap<String, Object>(parameters);
        LoggingLevel level = this.getLoggingLevel(parameters);
        String marker = this.getAndRemoveParameter(parameters, "marker", String.class);
        Integer groupSize = this.getAndRemoveParameter(parameters, "groupSize", Integer.class);
        Long groupInterval = this.getAndRemoveParameter(parameters, "groupInterval", Long.class);
        CamelLogger camelLogger = new CamelLogger(remaining, level, marker);
        if (groupSize != null) {
            logger = new ThroughputLogger(camelLogger, groupSize);
        } else if (groupInterval != null) {
            Boolean groupActiveOnly = this.getAndRemoveParameter(parameters, "groupActiveOnly", Boolean.class, Boolean.TRUE);
            Long groupDelay = this.getAndRemoveParameter(parameters, "groupDelay", Long.class);
            logger = new ThroughputLogger(camelLogger, this.getCamelContext(), groupInterval, groupDelay, groupActiveOnly);
        } else {
            ExchangeFormatter localFormatter = this.exchangeFormatter;
            if (localFormatter == null) {
                this.exchangeFormatter = localFormatter = this.getCamelContext().getRegistry().lookupByNameAndType("logFormatter", ExchangeFormatter.class);
            }
            if (localFormatter == null) {
                localFormatter = new DefaultExchangeFormatter();
                this.setProperties(localFormatter, parameters);
            }
            logger = new CamelLogProcessor(camelLogger, localFormatter);
        }
        LogEndpoint endpoint = new LogEndpoint(uri, this, (Processor)logger);
        this.setProperties(endpoint, originalParameters);
        return endpoint;
    }

    protected LoggingLevel getLoggingLevel(Map<String, Object> parameters) {
        String levelText = this.getAndRemoveParameter(parameters, "level", String.class, "INFO");
        return LoggingLevel.valueOf(levelText.toUpperCase(Locale.ENGLISH));
    }

    public ExchangeFormatter getExchangeFormatter() {
        return this.exchangeFormatter;
    }

    public void setExchangeFormatter(ExchangeFormatter exchangeFormatter) {
        this.exchangeFormatter = exchangeFormatter;
    }
}

