/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="json")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JsonDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private Boolean prettyPrint;
    @XmlAttribute
    private JsonLibrary library = JsonLibrary.XStream;
    @XmlAttribute
    private String unmarshalTypeName;
    @XmlTransient
    private Class<?> unmarshalType;
    @XmlAttribute
    private Class<?> jsonView;

    public JsonDataFormat() {
    }

    public JsonDataFormat(JsonLibrary library) {
        this.library = library;
    }

    public Boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public JsonLibrary getLibrary() {
        return this.library;
    }

    public void setLibrary(JsonLibrary library) {
        this.library = library;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    @Override
    protected DataFormat createDataFormat(RouteContext routeContext) {
        if (this.library == JsonLibrary.XStream) {
            this.setProperty(this, "dataFormatName", "json-xstream");
        } else if (this.library == JsonLibrary.Jackson) {
            this.setProperty(this, "dataFormatName", "json-jackson");
        } else {
            this.setProperty(this, "dataFormatName", "json-gson");
        }
        if (this.unmarshalType == null && this.unmarshalTypeName != null) {
            try {
                this.unmarshalType = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(this.unmarshalTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return super.createDataFormat(routeContext);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat) {
        if (this.unmarshalType != null) {
            this.setProperty(dataFormat, "unmarshalType", this.unmarshalType);
        }
        if (this.prettyPrint != null) {
            this.setProperty(dataFormat, "prettyPrint", this.unmarshalType);
        }
        if (this.jsonView != null) {
            this.setProperty(dataFormat, "jsonView", this.jsonView);
        }
    }
}

