/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.util.jsse.KeyStoreParameters;

@XmlRootElement(name="secureXML")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XMLSecurityDataFormat
extends DataFormatDefinition
implements NamespaceAware {
    private static final String TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    @XmlAttribute
    private String xmlCipherAlgorithm;
    @XmlAttribute
    private String passPhrase;
    @XmlAttribute
    private String secureTag;
    @XmlAttribute
    private Boolean secureTagContents;
    @XmlAttribute
    private String keyCipherAlgorithm;
    @XmlAttribute
    private String recipientKeyAlias;
    @XmlAttribute
    private String keyOrTrustStoreParametersId;
    @XmlAttribute
    private String keyPassword;
    @XmlAttribute
    private String digestAlgorithm;
    @XmlAttribute
    private String mgfAlgorithm;
    @XmlTransient
    private KeyStoreParameters keyOrTrustStoreParameters;
    @XmlTransient
    private Map<String, String> namespaces;

    public XMLSecurityDataFormat() {
        super("secureXML");
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
    }

    public XMLSecurityDataFormat(String secureTag, Map<String, String> namespaces, boolean secureTagContents) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setNamespaces(namespaces);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String passPhrase) {
        this(secureTag, secureTagContents);
        this.setPassPhrase(passPhrase);
    }

    public XMLSecurityDataFormat(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String passPhrase) {
        this(secureTag, secureTagContents);
        this.setPassPhrase(passPhrase);
        this.setNamespaces(namespaces);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String passPhrase, String xmlCipherAlgorithm) {
        this(secureTag, secureTagContents, passPhrase);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
    }

    public XMLSecurityDataFormat(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String passPhrase, String xmlCipherAlgorithm) {
        this(secureTag, secureTagContents, passPhrase);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setNamespaces(namespaces);
    }

    @Deprecated
    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm) {
        this(secureTag, secureTagContents);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, String keyOrTrustStoreParametersId) {
        this(secureTag, secureTagContents);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setKeyOrTrustStoreParametersId(keyOrTrustStoreParametersId);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters) {
        this(secureTag, secureTagContents);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setKeyOrTrustStoreParameters(keyOrTrustStoreParameters);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, String keyOrTrustStoreParametersId, String keyPassword) {
        this(secureTag, secureTagContents);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setKeyOrTrustStoreParametersId(keyOrTrustStoreParametersId);
        this.setKeyPassword(keyPassword);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters, String keyPassword) {
        this(secureTag, secureTagContents);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setKeyOrTrustStoreParameters(keyOrTrustStoreParameters);
        this.setKeyPassword(keyPassword);
    }

    @Deprecated
    public XMLSecurityDataFormat(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm) {
        this(secureTag, secureTagContents);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setNamespaces(namespaces);
    }

    public XMLSecurityDataFormat(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, String keyOrTrustStoreParametersId) {
        this(secureTag, secureTagContents);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setNamespaces(namespaces);
        this.setKeyOrTrustStoreParametersId(keyOrTrustStoreParametersId);
    }

    public XMLSecurityDataFormat(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters) {
        this(secureTag, secureTagContents);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setNamespaces(namespaces);
        this.setKeyOrTrustStoreParameters(keyOrTrustStoreParameters);
    }

    public XMLSecurityDataFormat(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, String keyOrTrustStoreParametersId, String keyPassword) {
        this(secureTag, secureTagContents);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setNamespaces(namespaces);
        this.setKeyOrTrustStoreParametersId(keyOrTrustStoreParametersId);
        this.setKeyPassword(keyPassword);
    }

    public XMLSecurityDataFormat(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters, String keyPassword) {
        this(secureTag, secureTagContents);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setNamespaces(namespaces);
        this.setKeyOrTrustStoreParameters(keyOrTrustStoreParameters);
        this.setKeyPassword(keyPassword);
    }

    public XMLSecurityDataFormat(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters, String keyPassword, String digestAlgorithm) {
        this(secureTag, secureTagContents);
        this.setRecipientKeyAlias(recipientKeyAlias);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        this.setKeyCipherAlgorithm(keyCipherAlgorithm);
        this.setNamespaces(namespaces);
        this.setKeyOrTrustStoreParameters(keyOrTrustStoreParameters);
        this.setKeyPassword(keyPassword);
        this.setDigestAlgorithm(digestAlgorithm);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat) {
        if (this.getSecureTag() != null) {
            this.setProperty(dataFormat, "secureTag", this.getSecureTag());
        } else {
            this.setProperty(dataFormat, "secureTag", "");
        }
        this.setProperty(dataFormat, "secureTagContents", this.isSecureTagContents());
        if (this.passPhrase != null) {
            this.setProperty(dataFormat, "passPhrase", this.getPassPhrase().getBytes());
        } else {
            this.setProperty(dataFormat, "passPhrase", "Just another 24 Byte key".getBytes());
        }
        if (this.getXmlCipherAlgorithm() != null) {
            this.setProperty(dataFormat, "xmlCipherAlgorithm", this.getXmlCipherAlgorithm());
        } else {
            this.setProperty(dataFormat, "xmlCipherAlgorithm", TRIPLEDES);
        }
        if (this.getKeyCipherAlgorithm() != null) {
            this.setProperty(dataFormat, "keyCipherAlgorithm", this.getKeyCipherAlgorithm());
        }
        if (this.getRecipientKeyAlias() != null) {
            this.setProperty(dataFormat, "recipientKeyAlias", this.getRecipientKeyAlias());
        }
        if (this.getKeyOrTrustStoreParametersId() != null) {
            this.setProperty(dataFormat, "keyOrTrustStoreParametersId", this.getKeyOrTrustStoreParametersId());
        }
        if (this.keyOrTrustStoreParameters != null) {
            this.setProperty(dataFormat, "keyOrTrustStoreParameters", this.keyOrTrustStoreParameters);
        }
        if (this.namespaces != null) {
            this.setProperty(dataFormat, "namespaces", this.namespaces);
        }
        if (this.keyPassword != null) {
            this.setProperty(dataFormat, "keyPassword", this.getKeyPassword());
        }
        if (this.digestAlgorithm != null) {
            this.setProperty(dataFormat, "digestAlgorithm", this.getDigestAlgorithm());
        }
        if (this.mgfAlgorithm != null) {
            this.setProperty(dataFormat, "mgfAlgorithm", this.getMgfAlgorithm());
        }
    }

    public String getXmlCipherAlgorithm() {
        return this.xmlCipherAlgorithm;
    }

    public void setXmlCipherAlgorithm(String xmlCipherAlgorithm) {
        this.xmlCipherAlgorithm = xmlCipherAlgorithm;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }

    public String getSecureTag() {
        return this.secureTag;
    }

    public void setSecureTag(String secureTag) {
        this.secureTag = secureTag;
    }

    public Boolean getSecureTagContents() {
        return this.secureTagContents;
    }

    public void setSecureTagContents(Boolean secureTagContents) {
        this.secureTagContents = secureTagContents;
    }

    public boolean isSecureTagContents() {
        return this.secureTagContents != null && this.secureTagContents != false;
    }

    public void setKeyCipherAlgorithm(String keyCipherAlgorithm) {
        this.keyCipherAlgorithm = keyCipherAlgorithm;
    }

    public String getKeyCipherAlgorithm() {
        return this.keyCipherAlgorithm;
    }

    public void setRecipientKeyAlias(String recipientKeyAlias) {
        this.recipientKeyAlias = recipientKeyAlias;
    }

    public String getRecipientKeyAlias() {
        return this.recipientKeyAlias;
    }

    public void setKeyOrTrustStoreParametersId(String id) {
        this.keyOrTrustStoreParametersId = id;
    }

    public String getKeyOrTrustStoreParametersId() {
        return this.keyOrTrustStoreParametersId;
    }

    private void setKeyOrTrustStoreParameters(KeyStoreParameters keyOrTrustStoreParameters) {
        this.keyOrTrustStoreParameters = keyOrTrustStoreParameters;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public String getMgfAlgorithm() {
        return this.mgfAlgorithm;
    }

    public void setMgfAlgorithm(String mgfAlgorithm) {
        this.mgfAlgorithm = mgfAlgorithm;
    }

    @Override
    public void setNamespaces(Map<String, String> nspaces) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
        }
        this.namespaces.putAll(nspaces);
    }
}

