/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterProcessor
extends DelegateAsyncProcessor
implements Traceable {
    private static final Logger LOG = LoggerFactory.getLogger(FilterProcessor.class);
    private final Predicate predicate;

    public FilterProcessor(Predicate predicate, Processor processor) {
        super(processor);
        this.predicate = predicate;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean matches = false;
        try {
            matches = this.predicate.matches(exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        LOG.debug("Filter matches: {} for exchange: {}", (Object)matches, (Object)exchange);
        exchange.setProperty("CamelFilterMatched", matches);
        if (matches) {
            return this.processor.process(exchange, callback);
        }
        callback.done(true);
        return true;
    }

    @Override
    public String toString() {
        return "Filter[if: " + this.predicate + " do: " + this.getProcessor() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "filter[if: " + this.predicate + "]";
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService(this.predicate);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.predicate);
        super.doStop();
    }
}

