/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.component;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.util.component.ApiMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiMethodHelper<T extends Enum<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(ApiMethodHelper.class);
    private final Map<String, List<T>> methodMap = new HashMap<String, List<T>>();
    private final Map<String, List<Object>> argumentsMap = new HashMap<String, List<Object>>();
    private final Map<String, Class<?>> validArguments = new HashMap();
    private final HashMap<String, Set<String>> aliasesMap = new HashMap();
    private final List<String> nullableArguments;

    public ApiMethodHelper(Class<T> apiMethodEnum, Map<String, String> aliases, List<String> nullableArguments) {
        Enum[] methods;
        if (apiMethodEnum == null) {
            throw new IllegalArgumentException("ApiMethod enumeration cannot be null");
        }
        this.nullableArguments = nullableArguments != null && !nullableArguments.isEmpty() ? Collections.unmodifiableList(new ArrayList<String>(nullableArguments)) : Collections.emptyList();
        HashMap<Pattern, String> aliasPatterns = new HashMap<Pattern, String>();
        for (Map.Entry<String, String> alias : aliases.entrySet()) {
            if (alias.getKey() == null || alias.getValue() == null) {
                throw new IllegalArgumentException("Alias pattern and replacement cannot be null");
            }
            aliasPatterns.put(Pattern.compile(alias.getKey()), alias.getValue());
        }
        LOG.debug("Processing " + apiMethodEnum.getName());
        for (Enum method : methods = (Enum[])apiMethodEnum.getEnumConstants()) {
            String name = ((ApiMethod)((Object)method)).getName();
            for (Map.Entry aliasEntry : aliasPatterns.entrySet()) {
                Set<String> names;
                Matcher matcher = ((Pattern)aliasEntry.getKey()).matcher(name);
                if (!matcher.find()) continue;
                String alias = matcher.replaceAll((String)aliasEntry.getValue());
                assert (alias.length() > 1);
                char firstChar = alias.charAt(0);
                if (!Character.isLowerCase(firstChar)) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(Character.toLowerCase(firstChar)).append(alias.substring(1));
                    alias = builder.toString();
                }
                if ((names = this.aliasesMap.get(alias)) == null) {
                    names = new HashSet<String>();
                    this.aliasesMap.put(alias, names);
                }
                names.add(name);
            }
            List<T> overloads = this.methodMap.get(name);
            if (overloads == null) {
                overloads = new ArrayList<T>();
                this.methodMap.put(((ApiMethod)((Object)method)).getName(), overloads);
            }
            overloads.add(method);
            List<Object> arguments = this.argumentsMap.get(name);
            if (arguments == null) {
                arguments = new ArrayList<Object>();
                this.argumentsMap.put(name, arguments);
            }
            int nArgs = ((ApiMethod)((Object)method)).getArgNames().size();
            String[] argNames = ((ApiMethod)((Object)method)).getArgNames().toArray(new String[nArgs]);
            Class[] argTypes = ((ApiMethod)((Object)method)).getArgTypes().toArray(new Class[nArgs]);
            for (int i = 0; i < nArgs; ++i) {
                Class<?> previousType;
                String argName = argNames[i];
                Class argType = argTypes[i];
                if (!arguments.contains(argName)) {
                    arguments.add(argType);
                    arguments.add(argName);
                }
                if ((previousType = this.validArguments.get(argName)) != null && previousType != argType) {
                    throw new IllegalArgumentException(String.format("Argument %s has ambiguous types (%s, %s) across methods!", name, previousType, argType));
                }
                if (previousType != null) continue;
                this.validArguments.put(argName, argType);
            }
        }
        if (!this.validArguments.keySet().containsAll(this.nullableArguments)) {
            ArrayList<String> unknowns = new ArrayList<String>(this.nullableArguments);
            unknowns.removeAll(this.validArguments.keySet());
            throw new IllegalArgumentException("Unknown nullable arguments " + ((Object)unknowns).toString());
        }
        for (Map.Entry<String, Set<String>> entry : this.aliasesMap.entrySet()) {
            Set<String> methodNames = entry.getValue();
            if (methodNames.size() <= 1) continue;
            ArrayList<T> aliasedMethods = new ArrayList<T>();
            for (String methodName : methodNames) {
                List<T> mappedMethods = this.methodMap.get(methodName);
                aliasedMethods.addAll(mappedMethods);
            }
            for (Enum method : aliasedMethods) {
                ArrayList<String> argNames = new ArrayList<String>(((ApiMethod)((Object)method)).getArgNames());
                argNames.removeAll(this.nullableArguments);
                HashSet<Enum> ambiguousMethods = new HashSet<Enum>();
                for (Enum otherMethod : aliasedMethods) {
                    if (method == otherMethod) continue;
                    ArrayList<String> otherArgsNames = new ArrayList<String>(((ApiMethod)((Object)otherMethod)).getArgNames());
                    otherArgsNames.removeAll(this.nullableArguments);
                    if (!argNames.equals(otherArgsNames)) continue;
                    ambiguousMethods.add(method);
                    ambiguousMethods.add(otherMethod);
                }
                if (ambiguousMethods.isEmpty()) continue;
                throw new IllegalArgumentException(String.format("Ambiguous alias %s for methods %s", entry.getKey(), ambiguousMethods));
            }
        }
        LOG.debug("Found {} unique method names in {} methods", (Object)this.methodMap.size(), (Object)methods.length);
    }

    public List<ApiMethod> getCandidateMethods(String name, String ... argNames) {
        int nArgs;
        List<T> methods = this.methodMap.get(name);
        if (methods == null && this.aliasesMap.containsKey(name)) {
            methods = new ArrayList<T>();
            for (String method : this.aliasesMap.get(name)) {
                methods.addAll((Collection)this.methodMap.get(method));
            }
        }
        if (methods == null) {
            LOG.debug("No matching method for method {}", (Object)name);
            return Collections.emptyList();
        }
        int n = nArgs = argNames != null ? argNames.length : 0;
        if (nArgs == 0) {
            LOG.debug("Found {} methods for method {}", (Object)methods.size(), (Object)name);
            return Collections.unmodifiableList(methods);
        }
        List<ApiMethod> filteredSet = this.filterMethods(methods, MatchType.SUBSET, argNames);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found {} filtered methods for {}", (Object)filteredSet.size(), (Object)(name + Arrays.toString(argNames).replace('[', '(').replace(']', ')')));
        }
        return filteredSet;
    }

    public List<ApiMethod> filterMethods(List<? extends ApiMethod> methods, MatchType matchType, String ... argNames) {
        ArrayList<String> withNullableArgsList;
        List<String> argsList = Arrays.asList(argNames);
        if (!this.nullableArguments.isEmpty()) {
            withNullableArgsList = new ArrayList<String>(argsList);
            withNullableArgsList.addAll(this.nullableArguments);
        } else {
            withNullableArgsList = null;
        }
        ArrayList<ApiMethod> result = new ArrayList<ApiMethod>();
        ArrayList<ApiMethod> extraArgs = new ArrayList<ApiMethod>();
        ArrayList<ApiMethod> nullArgs = new ArrayList<ApiMethod>();
        block4: for (ApiMethod apiMethod : methods) {
            List<String> methodArgs = apiMethod.getArgNames();
            switch (matchType) {
                case EXACT: {
                    if (!methodArgs.containsAll(argsList) || !argsList.containsAll(methodArgs)) continue block4;
                    result.add(apiMethod);
                    continue block4;
                }
                case SUBSET: {
                    if (!methodArgs.containsAll(argsList)) continue block4;
                    result.add(apiMethod);
                    continue block4;
                }
            }
            if (argsList.containsAll(methodArgs)) {
                if (methodArgs.containsAll(argsList)) {
                    result.add(apiMethod);
                    continue;
                }
                extraArgs.add(apiMethod);
                continue;
            }
            if (!result.isEmpty() || !extraArgs.isEmpty() || withNullableArgsList == null || !withNullableArgsList.containsAll(methodArgs)) continue;
            nullArgs.add(apiMethod);
        }
        return Collections.unmodifiableList(result.isEmpty() ? (extraArgs.isEmpty() ? nullArgs : extraArgs) : result);
    }

    public List<Object> getArguments(String name) throws IllegalArgumentException {
        List<Object> arguments = this.argumentsMap.get(name);
        if (arguments == null && this.aliasesMap.containsKey(name)) {
            arguments = new ArrayList<Object>();
            for (String method : this.aliasesMap.get(name)) {
                arguments.addAll((Collection<Object>)this.argumentsMap.get(method));
            }
        }
        if (arguments == null) {
            throw new IllegalArgumentException(name);
        }
        return Collections.unmodifiableList(arguments);
    }

    public Set<String> getMissingProperties(String methodName, Set<String> argNames) {
        List<Object> argsWithTypes = this.getArguments(methodName);
        HashSet<String> missingArgs = new HashSet<String>();
        for (int i = 1; i < argsWithTypes.size(); i += 2) {
            String name = (String)argsWithTypes.get(i);
            if (argNames.contains(name)) continue;
            missingArgs.add(name);
        }
        return missingArgs;
    }

    public Map<String, Set<String>> getAliases() {
        return Collections.unmodifiableMap(this.aliasesMap);
    }

    public Map<String, Class<?>> allArguments() {
        return Collections.unmodifiableMap(this.validArguments);
    }

    public List<String> getNullableArguments() {
        return this.nullableArguments;
    }

    public Class<?> getType(String argName) throws IllegalArgumentException {
        Class<?> type = this.validArguments.get(argName);
        if (type == null) {
            throw new IllegalArgumentException(argName);
        }
        return type;
    }

    public static ApiMethod getHighestPriorityMethod(List<? extends ApiMethod> filteredMethods) {
        Comparable highest = null;
        for (ApiMethod apiMethod : filteredMethods) {
            if (highest != null && highest.compareTo(apiMethod) > 0) continue;
            highest = (Comparable)((Object)apiMethod);
        }
        return (ApiMethod)((Object)highest);
    }

    public static Object invokeMethod(Object proxy, ApiMethod method, Map<String, Object> properties) throws RuntimeCamelException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking {} with arguments {}", (Object)method.getName(), properties);
        }
        List<String> argNames = method.getArgNames();
        Object[] values = new Object[argNames.size()];
        List<Class<?>> argTypes = method.getArgTypes();
        Class[] types = argTypes.toArray(new Class[argTypes.size()]);
        int index = 0;
        for (String name : argNames) {
            Object value = properties.get(name);
            if (value != null && types[index].isArray()) {
                int i;
                Object array;
                Class type = types[index];
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    array = Array.newInstance(type.getComponentType(), collection.size());
                    if (array instanceof Object[]) {
                        collection.toArray((Object[])array);
                    } else {
                        i = 0;
                        for (Object el : collection) {
                            Array.set(array, i++, el);
                        }
                    }
                    value = array;
                } else if (value.getClass().isArray() && type.getComponentType().isAssignableFrom(value.getClass().getComponentType())) {
                    if (type.getComponentType() != value.getClass().getComponentType()) {
                        int size = Array.getLength(value);
                        array = Array.newInstance(type.getComponentType(), size);
                        for (i = 0; i < size; ++i) {
                            Array.set(array, i, Array.get(value, i));
                        }
                        value = array;
                    }
                } else {
                    throw new IllegalArgumentException(String.format("Cannot convert %s to %s", value.getClass(), type));
                }
            }
            values[index++] = value;
        }
        try {
            return method.getMethod().invoke(proxy, values);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                Throwable cause = e.getCause();
                e = cause != null ? cause : e;
            }
            throw new RuntimeCamelException(String.format("Error invoking %s with %s: %s", method.getName(), properties, e.getMessage()), e);
        }
    }

    public static enum MatchType {
        EXACT,
        SUBSET,
        SUPER_SET;

    }
}

