/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BodyAndHeaderConvertTest
extends TestCase {
    protected Exchange exchange;

    public void testConversionOfBody() throws Exception {
        Document document = (Document)this.exchange.getIn().getBody(Document.class);
        BodyAndHeaderConvertTest.assertNotNull((Object)document);
        Element element = document.getDocumentElement();
        BodyAndHeaderConvertTest.assertEquals((String)"Root element name", (String)"hello", (String)element.getLocalName());
    }

    public void testConversionOfExchangeProperties() throws Exception {
        String text = (String)this.exchange.getProperty("foo", String.class);
        BodyAndHeaderConvertTest.assertEquals((String)"foo property", (String)"1234", (String)text);
    }

    public void testConversionOfMessageHeaders() throws Exception {
        String text = (String)this.exchange.getIn().getHeader("bar", String.class);
        BodyAndHeaderConvertTest.assertEquals((String)"bar header", (String)"567", (String)text);
    }

    public void testConversionOfMessageAttachments() throws Exception {
        DataHandler handler = this.exchange.getIn().getAttachment("att");
        BodyAndHeaderConvertTest.assertNotNull((String)"attachment got lost", (Object)handler);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.exchange = new DefaultExchange((CamelContext)new DefaultCamelContext());
        this.exchange.setProperty("foo", (Object)1234);
        Message message = this.exchange.getIn();
        message.setBody((Object)"<hello>world!</hello>");
        message.setHeader("bar", (Object)567);
        message.addAttachment("att", new DataHandler((DataSource)new URLDataSource(new URL("http://camel.apache.org/message.html"))));
    }
}

