/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.CamelContextHelper;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentDiscoveryTest {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentDiscoveryTest.class);

    @Test
    public void testComponentDiscovery() throws Exception {
        String[] expectedComponentNames;
        DefaultCamelContext context = new DefaultCamelContext();
        SortedMap map = CamelContextHelper.findComponents((CamelContext)context);
        Assert.assertNotNull((String)"Should never return null", (Object)map);
        Assert.assertTrue((String)"Component map should never be empty", (!map.isEmpty() ? 1 : 0) != 0);
        for (String expectedName : expectedComponentNames = new String[]{"file", "vm"}) {
            Properties properties = (Properties)map.get(expectedName);
            Assert.assertTrue((String)("Component map contain component: " + expectedName), (properties != null ? 1 : 0) != 0);
        }
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            LOG.info("Found component " + (String)entry.getKey() + " with properties: " + entry.getValue());
        }
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("bean");
        Assert.assertNotNull((String)"Should have found some auto-generated HTML", (Object)html);
        LOG.info("HTML: " + html);
    }
}

