/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import junit.framework.TestCase;
import org.apache.camel.Body;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Handler;
import org.apache.camel.Header;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.impl.DefaultExchange;

public class BeanHandlerMethodTest
extends ContextTestSupport {
    public void testNoHandleMethod() throws Exception {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyNoDummyBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyNoDummyBean pojo = new MyNoDummyBean();
        MethodInvocation mi = info.createInvocation((Object)pojo, (Exchange)exchange);
        BeanHandlerMethodTest.assertNotNull((Object)mi);
        BeanHandlerMethodTest.assertEquals((String)"hello", (String)mi.getMethod().getName());
    }

    public void testAmbigiousMethod() throws Exception {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyAmbigiousBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyAmbigiousBean pojo = new MyAmbigiousBean();
        try {
            info.createInvocation((Object)pojo, (Exchange)exchange);
            BeanHandlerMethodTest.fail((String)"Should have thrown an exception");
        }
        catch (AmbiguousMethodCallException e) {
            BeanHandlerMethodTest.assertEquals((int)2, (int)e.getMethods().size());
        }
    }

    public void testHandleMethod() throws Exception {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyDummyBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyDummyBean pojo = new MyDummyBean();
        MethodInvocation mi = info.createInvocation((Object)pojo, (Exchange)exchange);
        BeanHandlerMethodTest.assertNotNull((Object)mi);
        BeanHandlerMethodTest.assertEquals((String)"hello", (String)mi.getMethod().getName());
    }

    public void testHandleAndBodyMethod() throws Exception {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyOtherDummyBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyOtherDummyBean pojo = new MyOtherDummyBean();
        MethodInvocation mi = info.createInvocation((Object)pojo, (Exchange)exchange);
        BeanHandlerMethodTest.assertNotNull((Object)mi);
        BeanHandlerMethodTest.assertEquals((String)"hello", (String)mi.getMethod().getName());
    }

    public void testHandleAmbigious() throws Exception {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyReallyDummyBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyReallyDummyBean pojo = new MyReallyDummyBean();
        try {
            info.createInvocation((Object)pojo, (Exchange)exchange);
            BeanHandlerMethodTest.fail((String)"Should throw exception");
        }
        catch (AmbiguousMethodCallException e) {
            BeanHandlerMethodTest.assertEquals((int)2, (int)e.getMethods().size());
        }
    }

    public void testNoHandlerAmbigious() throws Exception {
        BeanInfo info = new BeanInfo((CamelContext)this.context, MyNoHandlerBean.class);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        MyNoHandlerBean pojo = new MyNoHandlerBean();
        try {
            info.createInvocation((Object)pojo, (Exchange)exchange);
            BeanHandlerMethodTest.fail((String)"Should throw exception");
        }
        catch (AmbiguousMethodCallException e) {
            BeanHandlerMethodTest.assertEquals((int)3, (int)e.getMethods().size());
        }
    }

    public static class MyReallyDummyBean {
        @Handler
        public String hello(String hi) {
            return "Hello " + hi;
        }

        @Handler
        public String bye(@Body String input) {
            TestCase.fail((String)"Should not invoke me");
            return null;
        }
    }

    public static class MyNoHandlerBean {
        public String hello(@Body String input, @Header(value="name") String name, @Header(value="age") int age) {
            TestCase.fail((String)"Should not invoke me");
            return null;
        }

        public String greeting(@Body String input, @Header(value="name") String name) {
            TestCase.fail((String)"Should not invoke me");
            return null;
        }

        public String bye(String input) {
            TestCase.fail((String)"Should not invoke me");
            return null;
        }
    }

    public static class MyOtherDummyBean {
        @Handler
        public String hello(String hi) {
            return "Hello " + hi;
        }

        public String bye(@Body String input) {
            TestCase.fail((String)"Should not invoke me");
            return null;
        }
    }

    public static class MyDummyBean {
        @Handler
        public String hello(String hi) {
            return "Hello " + hi;
        }

        public String doCompute(String input) {
            TestCase.fail((String)"Should not invoke me");
            return null;
        }
    }

    public static class MyAmbigiousBean {
        public String hello(String hi) {
            TestCase.fail((String)"Should not invoke me");
            return "Hello " + hi;
        }

        public String doCompute(String input) {
            TestCase.fail((String)"Should not invoke me");
            return null;
        }
    }

    public static class MyNoDummyBean {
        public String hello(@Body String hi) {
            return "Hello " + hi;
        }

        public String doCompute(String input) {
            TestCase.fail((String)"Should not invoke me");
            return null;
        }
    }
}

