/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BeanInvokeWithNullBodyTest
extends ContextTestSupport {
    public void testWithHelloWorld() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testWithEmptyBody() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{""});
        this.template.sendBody("direct:start", (Object)"");
        this.assertMockEndpointsSatisfied();
    }

    public void testWithNullBody() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:result").message(0).body()).isNull();
        this.template.sendBody("direct:start", null);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyNullFooBean());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("bean:foo")).to("mock:result");
            }
        };
    }

    private static class MyNullFooBean {
        private MyNullFooBean() {
        }

        public String doSomething(String s) {
            return s;
        }
    }
}

