/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BeanMethodWithStringParameterTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myBean", (Object)new MyBean());
        return jndi;
    }

    public void testBean() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello WorldHello World"});
        this.template.sendBody("direct:start", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    public void testBeanOther() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.template.sendBody("direct:other", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("bean:myBean?method=doSomething('Hello World', 2)")).to("mock:result");
                ((RouteDefinition)this.from("direct:other").to("bean:myBean?method=doSomethingWithExchange('Bye')")).to("mock:result");
            }
        };
    }

    public static final class MyBean {
        public static String doSomething(String name, int repeat) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < repeat; ++i) {
                sb.append(name);
            }
            return sb.toString();
        }

        public static String doSomethingWithExchange(String name, Exchange exchange) {
            return name + " " + (String)exchange.getIn().getBody(String.class);
        }
    }
}

