/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;

public class BeanOgnlBodyMethodReturnNullValueTest
extends ContextTestSupport {
    public void testBothValue() {
        ExamplePojo fooBar = new ExamplePojo();
        fooBar.setFoo("foo1");
        fooBar.setBar("bar2");
        String result = (String)this.template.requestBody("direct:start", (Object)fooBar, String.class);
        BeanOgnlBodyMethodReturnNullValueTest.assertEquals((String)"foo: foo1; bar: bar2", (String)result);
    }

    public void testNullValue() {
        ExamplePojo fooBar = new ExamplePojo();
        fooBar.setFoo(null);
        fooBar.setBar("test");
        String result = (String)this.template.requestBody("direct:start", (Object)fooBar, String.class);
        BeanOgnlBodyMethodReturnNullValueTest.assertEquals((String)"foo: null; bar: test", (String)result);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").bean((Object)new ExampleBean(), "doWithFooBar(${body.foo}, ${body.bar})");
            }
        };
    }

    public static class ExamplePojo {
        private String foo;
        private String bar;

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }

        public String getBar() {
            return this.bar;
        }

        public void setBar(String bar) {
            this.bar = bar;
        }
    }

    public static class ExampleBean {
        public String doWithFooBar(String foo, String bar) {
            return String.format("foo: %s; bar: %s", foo, bar);
        }
    }
}

