/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Header;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.model.RouteDefinition;

public class BeanOverloadedMethodTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testHelloOverloadedHeString() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(String)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
        this.assertMockEndpointsSatisfied();
    }

    public void testHelloOverloadedWildcard() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(*)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
        this.assertMockEndpointsSatisfied();
    }

    public void testHelloOverloadedStringString() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(String,String)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus you are from Denmark"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
        this.assertMockEndpointsSatisfied();
    }

    public void testHelloOverloadedWildcardString() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(*,String)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus you are from Denmark"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
        this.assertMockEndpointsSatisfied();
    }

    public void testHelloOverloadedWildcardWildcard() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(*,*)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus you are from Denmark"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
        this.assertMockEndpointsSatisfied();
    }

    public void testHelloOverloadedPickCamelAnnotated() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Claus you are from Denmark"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
        this.assertMockEndpointsSatisfied();
    }

    public void testHelloOverloadedAmbiguousStringStringString() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(String,String,String)")).to("mock:result");
            }
        });
        this.context.start();
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
            BeanOverloadedMethodTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            AmbiguousMethodCallException cause = BeanOverloadedMethodTest.assertIsInstanceOf(AmbiguousMethodCallException.class, e.getCause());
            BeanOverloadedMethodTest.assertEquals((int)2, (int)cause.getMethods().size());
        }
    }

    public void testHelloOverloadedStringInt() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(String,int)")).to("mock:result");
            }
        });
        this.context.start();
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
            BeanOverloadedMethodTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            AmbiguousMethodCallException cause = BeanOverloadedMethodTest.assertIsInstanceOf(AmbiguousMethodCallException.class, e.getCause());
            BeanOverloadedMethodTest.assertEquals((int)2, (int)cause.getMethods().size());
        }
    }

    public void testHelloOverloadedIntString() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "hello(int,String)")).to("mock:result");
            }
        });
        this.context.start();
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Claus", "country", (Object)"Denmark");
            BeanOverloadedMethodTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            AmbiguousMethodCallException cause = BeanOverloadedMethodTest.assertIsInstanceOf(AmbiguousMethodCallException.class, e.getCause());
            BeanOverloadedMethodTest.assertEquals((int)2, (int)cause.getMethods().size());
        }
    }

    public void testTimesOverloadedStringInt() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "times(String,int)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"AAA"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "times", (Object)"3");
        this.assertMockEndpointsSatisfied();
    }

    public void testTimesOverloadedBytesInt() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(MyBean.class, "times(byte[],int)")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"ABC,ABC,ABC"});
        this.template.sendBodyAndHeader("direct:start", (Object)"ABC".getBytes(), "times", (Object)"3");
        this.assertMockEndpointsSatisfied();
    }

    public static final class MyBean {
        public String hello(String name) {
            return "Hello " + name;
        }

        public String hello(String name, @Header(value="country") String country) {
            return "Hello " + name + " you are from " + country;
        }

        public String times(String name, @Header(value="times") int times) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < times; ++i) {
                sb.append(name);
            }
            return sb.toString();
        }

        public String times(byte[] data, @Header(value="times") int times) {
            String s = new String(data);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < times; ++i) {
                sb.append(s);
                if (i >= times - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }

        public String times(String name, int times, char separator) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < times; ++i) {
                sb.append(name);
                if (i >= times - 1) continue;
                sb.append(separator);
            }
            return sb.toString();
        }
    }
}

