/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BeanParameterNoBeanBindingTest
extends ContextTestSupport {
    public void testBeanParameterInvalidValueA() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:a", (Object)"World");
            BeanParameterNoBeanBindingTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            RuntimeExchangeException cause = BeanParameterNoBeanBindingTest.assertIsInstanceOf(RuntimeExchangeException.class, e.getCause());
            BeanParameterNoBeanBindingTest.assertTrue((boolean)cause.getMessage().contains("echo(java.lang.String,int)"));
            BeanParameterNoBeanBindingTest.assertTrue((boolean)cause.getMessage().contains("[World, null]"));
            BeanParameterNoBeanBindingTest.assertIsInstanceOf(IllegalArgumentException.class, cause.getCause());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyBean());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:a").to("bean:foo?method=echo")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public String echo(String body, int times) {
            if (body == null) {
                return "";
            }
            if (times > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < times; ++i) {
                    sb.append(body);
                }
                return sb.toString();
            }
            return body;
        }
    }
}

