/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BeanPropagateHeaderTest
extends ContextTestSupport {
    public void testBeanInOnlyPropagateHeaders() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Order OK for id: 123"});
        mock.expectedHeaderReceived("foo", (Object)"bar");
        String out = (String)this.template.requestBody("direct:start", (Object)"123", String.class);
        BeanPropagateHeaderTest.assertEquals((String)"OK", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("order", (Object)new MyOrderService());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").setHeader("foo", (Expression)this.constant("bar"))).convertBodyTo(Integer.class)).to("bean:order")).inOnly("seda:foo")).transform((Expression)this.constant("OK"));
                this.from("seda:foo").to("mock:result");
            }
        };
    }

    public static class MyOrderService {
        public String confirmOrder(int id) {
            return "Order OK for id: " + id;
        }
    }
}

