/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Headers;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Properties;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.BeanRouteTest;
import org.apache.camel.util.jndi.JndiContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanWithPropertiesAndHeadersInjectionTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BeanRouteTest.class);
    protected MyBean myBean = new MyBean();

    public void testSendMessage() throws Exception {
        this.template.send("direct:in", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setProperty("p1", (Object)"abc");
                exchange.setProperty("p2", (Object)123);
                Message in = exchange.getIn();
                in.setHeader("h1", (Object)"xyz");
                in.setHeader("h2", (Object)456);
            }
        });
        Map<?, ?> foo = this.myBean.foo;
        Map<?, ?> bar = this.myBean.bar;
        BeanWithPropertiesAndHeadersInjectionTest.assertNotNull((String)"myBean.foo", foo);
        BeanWithPropertiesAndHeadersInjectionTest.assertNotNull((String)"myBean.bar", bar);
        BeanWithPropertiesAndHeadersInjectionTest.assertEquals((String)"foo.p1", (Object)"abc", foo.get("p1"));
        BeanWithPropertiesAndHeadersInjectionTest.assertEquals((String)"foo.p2", (Object)123, foo.get("p2"));
        BeanWithPropertiesAndHeadersInjectionTest.assertEquals((String)"bar.h1", (Object)"xyz", bar.get("h1"));
        BeanWithPropertiesAndHeadersInjectionTest.assertEquals((String)"bar.h2", (Object)456, bar.get("h2"));
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").beanRef("myBean");
            }
        };
    }

    public static class MyBean {
        public Map<?, ?> foo;
        public Map<?, ?> bar;

        public String toString() {
            return "MyBean[foo: " + this.foo + " bar: " + this.bar + "]";
        }

        public void myMethod(@Properties Map<?, ?> foo, @Headers Map<?, ?> bar) {
            this.foo = foo;
            this.bar = bar;
            LOG.info("myMethod() method called on " + this);
        }
    }
}

