/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.SimpleDataSet;
import org.apache.camel.component.mock.MockEndpoint;

public class DataSetSedaTest
extends ContextTestSupport {
    private SimpleDataSet dataSet = new SimpleDataSet(200);
    private String uri = "dataset:foo?produceDelay=3";

    public void testDataSetWithSeda() throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint(this.uri);
        endpoint.expectedMessageCount((int)this.dataSet.getSize());
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        context.bind("foo", (Object)this.dataSet);
        return context;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from(DataSetSedaTest.this.uri).to("seda:test");
                this.from("seda:test").to(DataSetSedaTest.this.uri);
            }
        };
    }
}

