/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class DirectoryCreateIssueTest
extends ContextTestSupport {
    private final int numFiles = 10;
    private final String path = "target/a/b/c/d/e/f/g/h";

    @Override
    protected void setUp() throws Exception {
        DirectoryCreateIssueTest.deleteDirectory("target/a");
        super.setUp();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                String[] destinations = new String[10];
                for (int i = 0; i < 10; ++i) {
                    destinations[i] = "direct:file" + i;
                    ((RouteDefinition)this.from("direct:file" + i).setHeader("CamelFileName", (Expression)this.constant("file" + i + ".txt"))).to(new String[]{"file://target/a/b/c/d/e/f/g/h/?fileExist=Override&noop=true", "mock:result"});
                }
                this.from("seda:testFileCreatedAsDir").to(destinations);
            }
        };
    }

    public void testFileCreatedAsDir() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(10);
        this.template.send("seda:testFileCreatedAsDir", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody((Object)"Contents of test file");
            }
        });
        this.assertMockEndpointsSatisfied();
        Thread.sleep(200L);
        for (int i = 0; i < 10; ++i) {
            DirectoryCreateIssueTest.assertTrue((boolean)new File("target/a/b/c/d/e/f/g/h/file" + i + ".txt").isFile());
        }
    }
}

