/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileAbsoluteAndRelativeConsumerTest
extends ContextTestSupport {
    private String base;

    @Override
    protected void setUp() throws Exception {
        FileAbsoluteAndRelativeConsumerTest.deleteDirectory("target/filerelative");
        FileAbsoluteAndRelativeConsumerTest.deleteDirectory("target/fileabsolute");
        this.base = new File("").getAbsolutePath() + "/target/fileabsolute";
        super.setUp();
    }

    public void testRelative() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:relative");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).header("CamelFileName")).isEqualTo((Object)("test" + File.separator + "hello.txt"));
        ((ValueBuilder)mock.message(0).header("CamelFileNameOnly")).isEqualTo((Object)"hello.txt");
        this.template.sendBodyAndHeader("file://target/filerelative", (Object)"Hello World", "CamelFileName", (Object)"test/hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testAbsolute() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:absolute");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).header("CamelFileName")).isEqualTo((Object)("test" + File.separator + "hello.txt"));
        ((ValueBuilder)mock.message(0).header("CamelFileNameOnly")).isEqualTo((Object)"hello.txt");
        this.template.sendBodyAndHeader("file://target/fileabsolute", (Object)"Hello World", "CamelFileName", (Object)"test/hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/filerelative?recursive=true").convertBodyTo(String.class)).to("mock:relative");
                ((RouteDefinition)this.from("file://" + FileAbsoluteAndRelativeConsumerTest.this.base + "?recursive=true").convertBodyTo(String.class)).to("mock:absolute");
            }
        };
    }
}

