/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.file.FileComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class FileComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        FileComponent comp = (FileComponent)this.context.getComponent("file", FileComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("file:target/foo?delete=true");
        FileComponentConfigurationAndDocumentationTest.assertEquals((Object)"true", (Object)conf.getParameter("delete"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        FileComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        FileComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"doneFileName\": { \"kind\": \"parameter\", \"label\": \"producer\", \"type\": \"string\""));
        FileComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"exclude\": { \"kind\": \"parameter\", \"label\": \"consumer\", \"type\": \"string\""));
        FileComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"delete\": { \"kind\": \"parameter\", \"label\": \"consumer\", \"type\": \"boolean\""));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("file");
        FileComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML", (Object)html);
    }
}

