/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumeFilesAndDeleteTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumeFilesAndDeleteTest.deleteDirectory("target/files");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/files", (Object)"Hello World", "CamelFileName", (Object)"report.txt");
        this.template.sendBodyAndHeader("file://target/files", (Object)"Bye World", "CamelFileName", (Object)"report2.txt");
        this.template.sendBodyAndHeader("file://target/files/2008", (Object)"2008 Report", "CamelFileName", (Object)"report2008.txt");
    }

    public void testConsumeAndDelete() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        FileConsumeFilesAndDeleteTest.assertFalse((String)"File should been deleted", (boolean)new File("target/files/report.txt").exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/files/?fileName=report.txt&delete=true").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

