/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumeMultipleDirectoriesTest
extends ContextTestSupport {
    private String fileUrl = "file://target/multidir/?recursive=true&delete=true&initialDelay=2000&delay=5000&sortBy=file:path";

    @Override
    protected void setUp() throws Exception {
        FileConsumeMultipleDirectoriesTest.deleteDirectory("target/multidir");
        super.setUp();
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"Hello World", "CamelFileName", (Object)"sub/hello.txt");
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"Godday World", "CamelFileName", (Object)"sub/sub2/godday.txt");
    }

    public void testMultiDir() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World", "Hello World", "Godday World"});
        this.assertMockEndpointsSatisfied();
        Exchange exchange = (Exchange)mock.getExchanges().get(0);
        GenericFile gf = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
        File file = (File)gf.getFile();
        FileConsumeMultipleDirectoriesTest.assertDirectoryEquals("target/multidir/bye.txt", file.getPath());
        FileConsumeMultipleDirectoriesTest.assertEquals((String)"bye.txt", (String)file.getName());
        exchange = (Exchange)mock.getExchanges().get(1);
        gf = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
        file = (File)gf.getFile();
        FileConsumeMultipleDirectoriesTest.assertDirectoryEquals("target/multidir/sub/hello.txt", file.getPath());
        FileConsumeMultipleDirectoriesTest.assertEquals((String)"hello.txt", (String)file.getName());
        exchange = (Exchange)mock.getExchanges().get(2);
        gf = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
        file = (File)gf.getFile();
        FileConsumeMultipleDirectoriesTest.assertDirectoryEquals("target/multidir/sub/sub2/godday.txt", file.getPath());
        FileConsumeMultipleDirectoriesTest.assertEquals((String)"godday.txt", (String)file.getName());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileConsumeMultipleDirectoriesTest.this.fileUrl).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

