/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerCommitRenameAbsolutePathStrategyTest
extends ContextTestSupport {
    private String base;

    @Override
    protected void setUp() throws Exception {
        FileConsumerCommitRenameAbsolutePathStrategyTest.deleteDirectory("target/done");
        FileConsumerCommitRenameAbsolutePathStrategyTest.deleteDirectory("target/reports");
        this.base = new File("").getAbsolutePath() + "/target";
        super.setUp();
    }

    public void testRenameSuccess() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedBodiesReceived(new Object[]{"Hello Paris"});
        mock.expectedFileExists("target/done/paris.txt", "Hello Paris");
        this.template.sendBodyAndHeader("file:target/reports", (Object)"Hello Paris", "CamelFileName", (Object)"paris.txt");
        mock.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/reports?move=" + FileConsumerCommitRenameAbsolutePathStrategyTest.this.base + "/done/${file:name}&consumer.delay=5000").convertBodyTo(String.class)).to("mock:report");
            }
        };
    }
}

