/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerDirectoryNotMatchedTest
extends ContextTestSupport {
    private String fileUrl = "file://target/dirnotmatched/?recursive=true&include=.*txt$";

    @Override
    protected void setUp() throws Exception {
        FileConsumerDirectoryNotMatchedTest.deleteDirectory("target/dirnotmatched");
        super.setUp();
        this.template.sendBodyAndHeader("file:target/dirnotmatched/", (Object)"This is a dot file", "CamelFileName", (Object)".skipme");
        this.template.sendBodyAndHeader("file:target/dirnotmatched/", (Object)"This is a web file", "CamelFileName", (Object)"index.html");
        this.template.sendBodyAndHeader("file:target/dirnotmatched/2007", (Object)"2007 report", "CamelFileName", (Object)"report2007.txt");
        this.template.sendBodyAndHeader("file:target/dirnotmatched/2008", (Object)"2008 report", "CamelFileName", (Object)"report2008.txt");
    }

    public void testSkipDirectories() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileConsumerDirectoryNotMatchedTest.this.fileUrl).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

