/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.PollingConsumerPollStrategy;

public class FileConsumerPollStrategyPolledMessagesTest
extends ContextTestSupport {
    private static int maxPolls;
    private final CountDownLatch latch = new CountDownLatch(1);
    private String fileUrl = "file://target/pollstrategy/?consumer.pollStrategy=#myPoll";

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myPoll", (Object)new MyPollStrategy());
        return jndi;
    }

    @Override
    protected void setUp() throws Exception {
        FileConsumerPollStrategyPolledMessagesTest.deleteDirectory("target/pollstrategy");
        super.setUp();
    }

    public void testPolledMessages() throws Exception {
        this.template.sendBodyAndHeader("file:target/pollstrategy/", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file:target/pollstrategy/", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.context.startRoute("foo");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        this.assertMockEndpointsSatisfied();
        FileConsumerPollStrategyPolledMessagesTest.assertTrue((boolean)this.latch.await(5L, TimeUnit.SECONDS));
        FileConsumerPollStrategyPolledMessagesTest.assertEquals((int)2, (int)maxPolls);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileConsumerPollStrategyPolledMessagesTest.this.fileUrl).routeId("foo").noAutoStartup().convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    private class MyPollStrategy
    implements PollingConsumerPollStrategy {
        private MyPollStrategy() {
        }

        public boolean begin(Consumer consumer, Endpoint endpoint) {
            return true;
        }

        public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
            if (polledMessages > maxPolls) {
                maxPolls = polledMessages;
            }
            FileConsumerPollStrategyPolledMessagesTest.this.latch.countDown();
        }

        public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception cause) throws Exception {
            return false;
        }
    }
}

