/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.PollingConsumerPollStrategy;

public class FileConsumerPollStrategyRollbackThrowExceptionTest
extends ContextTestSupport {
    private static volatile String event = "";
    private String fileUrl = "file://target/pollstrategy/?pollStrategy=#myPoll&initialDelay=0&delay=10";

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myPoll", (Object)new MyPollStrategy());
        return jndi;
    }

    @Override
    protected void setUp() throws Exception {
        FileConsumerPollStrategyRollbackThrowExceptionTest.deleteDirectory("target/pollstrategy");
        super.setUp();
        this.template.sendBodyAndHeader("file:target/pollstrategy/", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
    }

    public void testRollbackThrowException() throws Exception {
        Thread.sleep(200L);
        FileConsumerPollStrategyRollbackThrowExceptionTest.assertTrue((boolean)event.startsWith("rollback"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileConsumerPollStrategyRollbackThrowExceptionTest.this.fileUrl).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    private static class MyPollStrategy
    implements PollingConsumerPollStrategy {
        private MyPollStrategy() {
        }

        public boolean begin(Consumer consumer, Endpoint endpoint) {
            throw new IllegalArgumentException("Damn I cannot do this");
        }

        public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
            event = event + "commit";
        }

        public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception cause) throws Exception {
            event = event + "rollback";
            throw cause;
        }
    }
}

