/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;

public class FilePollEnrichNoWaitTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FilePollEnrichNoWaitTest.deleteDirectory("target/pollenrich");
        super.setUp();
    }

    public void testFilePollEnrichNoWait() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedFileExists("target/pollenrich/done/hello.txt");
        this.template.sendBodyAndHeader("file:target/pollenrich", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File file = new File("target/pollenrich/hello.txt");
        FilePollEnrichNoWaitTest.assertFalse((String)"File should have been moved", (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("timer:foo?period=1000").routeId("foo").log("Trigger timer foo")).pollEnrich("file:target/pollenrich?move=done", 0L)).convertBodyTo(String.class)).filter(this.body().isNull()).stop()).end().log("Polled filed ${file:name}").to("mock:result");
            }
        };
    }
}

