/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileProducerAllowNullBodyFileAlreadyExistsTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileProducerAllowNullBodyFileAlreadyExistsTest.deleteDirectory("target/allow");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/allow", (Object)"Hello world", "CamelFileName", (Object)"hello.txt");
    }

    public void testFileExistAppendAllowNullBody() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:appendTypeAppendResult");
        mock.expectedMessageCount(1);
        mock.expectedFileExists("target/allow/hello.txt", "Hello world");
        this.template.sendBody("direct:appendTypeAppend", null);
        this.assertMockEndpointsSatisfied();
    }

    public void testFileExistOverrideAllowNullBody() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:appendTypeOverrideResult");
        mock.expectedMessageCount(1);
        mock.expectedFileExists("target/allow/hello.txt", "");
        this.template.sendBody("direct:appendTypeOverride", null);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:appendTypeAppend").setHeader("CamelFileName", (Expression)this.constant("hello.txt"))).to("file://target/allow?allowNullBody=true&fileExist=Append")).to("mock:appendTypeAppendResult");
                ((RouteDefinition)((RouteDefinition)this.from("direct:appendTypeOverride").setHeader("CamelFileName", (Expression)this.constant("hello.txt"))).to("file://target/allow?allowNullBody=true&fileExist=Override")).to("mock:appendTypeOverrideResult");
            }
        };
    }
}

