/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.util.IOHelper;

public class FileProducerCharsetUTFOptimizedTest
extends ContextTestSupport {
    private byte[] utf;

    @Override
    protected void setUp() throws Exception {
        this.utf = "ABC\u00e6".getBytes("utf-8");
        FileProducerCharsetUTFOptimizedTest.deleteDirectory("target/charset");
        FileProducerCharsetUTFOptimizedTest.createDirectory("target/charset/input");
        this.log.debug("utf: {}", (Object)new String(this.utf, Charset.forName("utf-8")));
        for (byte b : this.utf) {
            this.log.debug("utf byte: {}", (Object)b);
        }
        FileOutputStream fos = new FileOutputStream("target/charset/input/input.txt");
        fos.write(this.utf);
        fos.close();
        super.setUp();
    }

    public void testFileProducerCharsetUTFOptimized() throws Exception {
        this.oneExchangeDone.matchesMockWaitTime();
        File file = new File("target/charset/output.txt");
        FileProducerCharsetUTFOptimizedTest.assertTrue((String)"File should exist", (boolean)file.exists());
        BufferedInputStream fis = IOHelper.buffered((InputStream)new FileInputStream(file));
        byte[] buffer = new byte[100];
        int len = ((InputStream)fis).read(buffer);
        FileProducerCharsetUTFOptimizedTest.assertTrue((String)("Should read data: " + len), (len != -1 ? 1 : 0) != 0);
        byte[] data = new byte[len];
        System.arraycopy(buffer, 0, data, 0, len);
        ((InputStream)fis).close();
        FileProducerCharsetUTFOptimizedTest.assertEquals((int)5, (int)data.length);
        FileProducerCharsetUTFOptimizedTest.assertEquals((int)65, (int)data[0]);
        FileProducerCharsetUTFOptimizedTest.assertEquals((int)66, (int)data[1]);
        FileProducerCharsetUTFOptimizedTest.assertEquals((int)67, (int)data[2]);
        FileProducerCharsetUTFOptimizedTest.assertEquals((int)-61, (int)data[3]);
        FileProducerCharsetUTFOptimizedTest.assertEquals((int)-90, (int)data[4]);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file:target/charset/input?noop=true").to("file:target/charset/?fileName=output.txt");
            }
        };
    }
}

