/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.language.simple.SimpleLanguage;

public class FileProducerExpressionTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileProducerExpressionTest.deleteDirectory("target/filelanguage");
        super.setUp();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myguidgenerator", (Object)new MyGuidGenerator());
        return jndi;
    }

    public void testProducerFileNameHeaderNotEvaluated() {
        if (!FileProducerExpressionTest.isPlatform("windows")) {
            this.template.sendBodyAndHeader("file://target/filelanguage", (Object)"Hello World", "CamelFileName", (Object)"$simple{myfile-${date:now:yyyyMMdd}}.txt");
            FileProducerExpressionTest.assertFileExists("target/filelanguage/$simple{myfile-${date:now:yyyyMMdd}}.txt");
        }
    }

    public void testProduceBeanByExpression() throws Exception {
        this.template.sendBody("file://target/filelanguage?fileName=${bean:myguidgenerator}.bak", (Object)"Hello World");
        FileProducerExpressionTest.assertFileExists("target/filelanguage/123.bak");
    }

    public void testProducerDateByHeader() throws Exception {
        this.template.sendBodyAndHeader("file://target/filelanguage", (Object)"Hello World", "CamelFileName", (Object)SimpleLanguage.simple((String)"myfile-${date:now:yyyyMMdd}.txt"));
        String date = new SimpleDateFormat("yyyyMMdd").format(new Date());
        FileProducerExpressionTest.assertFileExists("target/filelanguage/myfile-" + date + ".txt");
    }

    public void testProducerDateByExpression() throws Exception {
        this.template.sendBody("file://target/filelanguage?fileName=myfile-${date:now:yyyyMMdd}.txt", (Object)"Hello World");
        String date = new SimpleDateFormat("yyyyMMdd").format(new Date());
        FileProducerExpressionTest.assertFileExists("target/filelanguage/myfile-" + date + ".txt");
    }

    public void testProducerComplexByExpression() throws Exception {
        String expression = "../filelanguageinbox/myfile-${bean:myguidgenerator.guid}-${date:now:yyyyMMdd}.txt";
        this.template.sendBody("file://target/filelanguage?fileName=" + expression, (Object)"Hello World");
        String date = new SimpleDateFormat("yyyyMMdd").format(new Date());
        FileProducerExpressionTest.assertFileExists("target/filelanguageinbox/myfile-123-" + date + ".txt");
    }

    public void testProducerSimpleWithHeaderByExpression() throws Exception {
        this.template.sendBodyAndHeader("file://target/filelanguage?fileName=myfile-${in.header.foo}.txt", (Object)"Hello World", "foo", (Object)"abc");
        FileProducerExpressionTest.assertFileExists("target/filelanguage/myfile-abc.txt");
    }

    public void testProducerWithDateHeader() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.set(1974, 3, 20);
        Date date = cal.getTime();
        this.template.sendBodyAndHeader("file://target/filelanguage?fileName=mybirthday-${date:in.header.birthday:yyyyMMdd}.txt", (Object)"Hello World", "birthday", (Object)date);
        FileProducerExpressionTest.assertFileExists("target/filelanguage/mybirthday-19740420.txt");
    }

    public class MyGuidGenerator {
        public String guid() {
            return "123";
        }
    }
}

