/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.file.GenericFileOperationFailedException;

public class FileProducerMoveExistingTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileProducerMoveExistingTest.deleteDirectory("target/file");
        super.setUp();
    }

    public void testExistingFileDoesNotExists() throws Exception {
        this.template.sendBodyAndHeader("file://target/file?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        FileProducerMoveExistingTest.assertFileExists("target/file/hello.txt");
        FileProducerMoveExistingTest.assertFileNotExists("target/file/renamed-hello.txt");
    }

    public void testExistingFileExists() throws Exception {
        this.template.sendBodyAndHeader("file://target/file?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file://target/file?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}", (Object)"Bye World", "CamelFileName", (Object)"hello.txt");
        FileProducerMoveExistingTest.assertFileExists("target/file/hello.txt");
        FileProducerMoveExistingTest.assertEquals((String)"Bye World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/file/hello.txt"))));
        FileProducerMoveExistingTest.assertFileExists("target/file/renamed-hello.txt");
        FileProducerMoveExistingTest.assertEquals((String)"Hello World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/file/renamed-hello.txt"))));
    }

    public void testExistingFileExistsMoveSubDir() throws Exception {
        this.template.sendBodyAndHeader("file://target/file?fileExist=Move&moveExisting=backup", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file://target/file?fileExist=Move&moveExisting=backup", (Object)"Bye World", "CamelFileName", (Object)"hello.txt");
        FileProducerMoveExistingTest.assertFileExists("target/file/hello.txt");
        FileProducerMoveExistingTest.assertEquals((String)"Bye World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/file/hello.txt"))));
        FileProducerMoveExistingTest.assertFileExists("target/file/backup/hello.txt");
        FileProducerMoveExistingTest.assertEquals((String)"Hello World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/file/backup/hello.txt"))));
    }

    public void testFailOnMoveExistingFileExistsEagerDeleteTrue() throws Exception {
        this.template.sendBodyAndHeader("file://target/file", (Object)"Old file", "CamelFileName", (Object)"renamed-hello.txt");
        this.template.sendBodyAndHeader("file://target/file?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}&eagerDeleteTargetFile=true", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file://target/file?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}&eagerDeleteTargetFile=true", (Object)"Bye World", "CamelFileName", (Object)"hello.txt");
        FileProducerMoveExistingTest.assertFileExists("target/file/hello.txt");
        FileProducerMoveExistingTest.assertEquals((String)"Bye World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/file/hello.txt"))));
        FileProducerMoveExistingTest.assertFileExists("target/file/renamed-hello.txt");
        FileProducerMoveExistingTest.assertEquals((String)"Hello World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/file/renamed-hello.txt"))));
    }

    public void testFailOnMoveExistingFileExistsEagerDeleteFalse() throws Exception {
        this.template.sendBodyAndHeader("file://target/file", (Object)"Old file", "CamelFileName", (Object)"renamed-hello.txt");
        this.template.sendBodyAndHeader("file://target/file?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}&eagerDeleteTargetFile=false", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        try {
            this.template.sendBodyAndHeader("file://target/file?fileExist=Move&moveExisting=${file:parent}/renamed-${file:onlyname}&eagerDeleteTargetFile=false", (Object)"Bye World", "CamelFileName", (Object)"hello.txt");
            FileProducerMoveExistingTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            GenericFileOperationFailedException cause = FileProducerMoveExistingTest.assertIsInstanceOf(GenericFileOperationFailedException.class, e.getCause());
            FileProducerMoveExistingTest.assertTrue((boolean)cause.getMessage().startsWith("Cannot moved existing file"));
        }
        FileProducerMoveExistingTest.assertFileExists("target/file/hello.txt");
        FileProducerMoveExistingTest.assertEquals((String)"Hello World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/file/hello.txt"))));
        FileProducerMoveExistingTest.assertFileExists("target/file/renamed-hello.txt");
        FileProducerMoveExistingTest.assertEquals((String)"Old file", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/file/renamed-hello.txt"))));
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

