/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileRenameReadLockMustUseMarkerFileTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        FileRenameReadLockMustUseMarkerFileTest.deleteDirectory("target/rename");
        this.template.sendBodyAndHeader("file:target/rename", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
    }

    public void testCamelLockFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        ((ValueBuilder)mock.message(0).header("CamelFileName")).isEqualTo((Object)"bye.txt");
        this.context.startRoute("foo");
        this.assertMockEndpointsSatisfied();
        FileRenameReadLockMustUseMarkerFileTest.assertTrue((boolean)this.oneExchangeDone.matchesMockWaitTime());
        File lock = new File("target/rename/bye.txt.camelLock");
        FileRenameReadLockMustUseMarkerFileTest.assertFalse((String)("Lock file should not exist: " + lock), (boolean)lock.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("file:target/rename?readLock=rename").routeId("foo").noAutoStartup().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String name = exchange.getIn().getHeader("CamelFilePath") + ".camelLock";
                        File lock = new File(name);
                        TestCase.assertTrue((String)("Lock file should exist: " + name), (boolean)lock.exists());
                    }
                })).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

