/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.stress;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;

public class FileProducerAppendManyMessagesFastTest
extends ContextTestSupport {
    private boolean enabled;

    @Override
    protected void setUp() throws Exception {
        if (!this.enabled) {
            return;
        }
        FileProducerAppendManyMessagesFastTest.deleteDirectory("target/big");
        FileProducerAppendManyMessagesFastTest.createDirectory("target/big");
        FileProducerAppendManyMessagesFastTest.deleteDirectory("target/out");
        FileProducerAppendManyMessagesFastTest.createDirectory("target/out");
        File file = new File("target/big/data.txt");
        FileOutputStream fos = new FileOutputStream(file);
        for (int i = 0; i < 100000; ++i) {
            String s = "Hello World this is a long line with number " + i + LS;
            fos.write(s.getBytes());
        }
        fos.close();
        super.setUp();
    }

    public void testBigFile() throws Exception {
        if (!this.enabled) {
            return;
        }
        MockEndpoint mock = this.getMockEndpoint("mock:done");
        mock.expectedMessageCount(1);
        mock.setResultWaitTime(120000L);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((ExpressionNode)((RouteDefinition)this.from("file:target/big").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        FileOutputStream fos = new FileOutputStream("target/out/also-big.txt", true);
                        exchange.setProperty("myStream", (Object)fos);
                    }
                })).split((Expression)this.body().tokenize(LS)).streaming().to("log:processing?groupSize=1000")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        OutputStream fos = (OutputStream)exchange.getProperty("myStream", OutputStream.class);
                        byte[] data = (byte[])exchange.getIn().getBody(byte[].class);
                        fos.write(data);
                        fos.write(LS.getBytes());
                    }
                })).end().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        OutputStream fos = (OutputStream)exchange.getProperty("myStream", OutputStream.class);
                        fos.close();
                        exchange.removeProperty("myStream");
                    }
                }).to("mock:done");
            }
        };
    }
}

