/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.stress;

import java.io.File;
import java.io.FileOutputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;

public class FileProducerAppendManyMessagesTest
extends ContextTestSupport {
    private boolean enabled;

    @Override
    protected void setUp() throws Exception {
        if (!this.enabled) {
            return;
        }
        FileProducerAppendManyMessagesTest.deleteDirectory("target/big");
        FileProducerAppendManyMessagesTest.createDirectory("target/big");
        File file = new File("target/big/data.txt");
        FileOutputStream fos = new FileOutputStream(file);
        for (int i = 0; i < 100000; ++i) {
            String s = "Hello World this is a long line with number " + i + LS;
            fos.write(s.getBytes());
        }
        fos.close();
        super.setUp();
    }

    public void testBigFile() throws Exception {
        if (!this.enabled) {
            return;
        }
        MockEndpoint mock = this.getMockEndpoint("mock:done");
        mock.expectedMessageCount(1);
        mock.setResultWaitTime(120000L);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((ExpressionNode)this.from("file:target/big").split((Expression)this.body().tokenize(LS)).streaming().to("log:processing?groupSize=1000")).to("file:target/out/also-big.txt?fileExist=Append")).end().to("mock:done");
            }
        };
    }
}

