/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.mock.MockComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class MockComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        MockComponent comp = (MockComponent)this.context.getComponent("mock", MockComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("mock:foo?retainFirst=10");
        MockComponentConfigurationAndDocumentationTest.assertEquals((Object)"10", (Object)conf.getParameter("retainFirst"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        MockComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        MockComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"name\": { \"kind\": \"path\", \"required\": \"true\", \"type\": \"string\""));
        MockComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"expectedCount\": { \"kind\": \"parameter\", \"type\": \"integer\""));
        MockComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"retainFirst\": { \"kind\": \"parameter\", \"type\": \"integer\""));
    }

    @Test
    public void testEndpointExplain() throws Exception {
        String json = this.context.explainEndpointJson("mock:foo?retainFirst=10", true);
        MockComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        MockComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"name\": { \"kind\": \"path\", \"required\": \"true\", \"type\": \"string\", \"javaType\": \"java.lang.String\", \"deprecated\": \"false\", \"value\": \"foo\", \"description\": \"Name of mock endpoint\""));
        MockComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"expectedCount\": { \"kind\": \"parameter\", \"type\": \"integer\""));
        MockComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"retainFirst\": { \"kind\": \"parameter\", \"type\": \"integer\""));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("mock");
        MockComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML", (Object)html);
    }
}

