/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class MockPredicateTest
extends ContextTestSupport {
    public void testMockPredicate() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:foo");
        mock.message(0).predicate().header("foo");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"bar");
        this.assertMockEndpointsSatisfied();
    }

    public void testMockPredicateAsParameter() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:foo");
        mock.message(0).predicate(PredicateBuilder.isNotNull((Expression)MockPredicateTest.header("foo")));
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"bar");
        this.assertMockEndpointsSatisfied();
    }

    public void testOutBodyType() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:foo");
        ((ValueBuilder)mock.message(0).outBody(String.class)).isEqualTo((Object)"Bye World");
        mock.expectedMessageCount(1);
        this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello World");
                exchange.getOut().setBody((Object)"Bye World");
            }
        });
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:foo");
            }
        };
    }
}

