/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

public class PropertiesComponentDefaultFunctionsTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testFunction() throws Exception {
        System.setProperty("FOO", "mock:foo");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ProcessorDefinition)((RouteDefinition)this.from("direct:start").to("{{sys:FOO}}")).transform().constant((Object)"{{env:JAVA_HOME}}")).to("mock:bar");
            }
        });
        this.context.start();
        String body = System.getenv("JAVA_HOME");
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{body});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        System.getProperties().remove("FOO");
    }

    public void testFunctionGetOrElse() throws Exception {
        System.setProperty("FOO2", "mock:foo");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("{{sys:FOO2}}")).to("{{env:BAR2:mock:bar}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        System.getProperties().remove("FOO2");
    }
}

