/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.io.FileNotFoundException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;

public class PropertiesComponentDefaultTest
extends ContextTestSupport {
    public void testPropertiesComponentDefault() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:bar.end?locations=org/apache/camel/component/properties/bar.properties");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testPropertiesComponentDefaultNoFileFound() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:bar.end?locations=org/apache/camel/component/properties/unknown.properties");
            }
        });
        try {
            this.context.start();
            PropertiesComponentDefaultTest.fail((String)"Should throw exception");
        }
        catch (FailedToCreateRouteException e) {
            ResolveEndpointFailedException cause = PropertiesComponentDefaultTest.assertIsInstanceOf(ResolveEndpointFailedException.class, e.getCause());
            FileNotFoundException fnfe = PropertiesComponentDefaultTest.assertIsInstanceOf(FileNotFoundException.class, cause.getCause());
            PropertiesComponentDefaultTest.assertEquals((String)"Properties file org/apache/camel/component/properties/unknown.properties not found in classpath", (String)fnfe.getMessage());
        }
    }

    public void testIgnoreMissingPropertyFilesOnClasspath() throws Exception {
        System.setProperty("bar.end", "mock:bar");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:bar.end?locations=org/apache/camel/component/properties/unknown.properties&ignoreMissingLocation=true");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testIgnoreMissingPropertyFilesFromRegistry() throws Exception {
        System.setProperty("bar.end", "mock:bar");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:bar.end?locations=ref:unknown.properties&ignoreMissingLocation=true");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testIgnoreMissingPropertyFilesFromFilePath() throws Exception {
        System.setProperty("bar.end", "mock:bar");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:bar.end?locations=file:unknown.properties&ignoreMissingLocation=true");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testIgnoreMissingPropertySystemPropertyOnClasspath() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:bar.end?locations=${my.home}/unknown.properties,org/apache/camel/component/properties/bar.properties&ignoreMissingLocation=true");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testNotIgnoreMissingPropertySystemPropertyOnClasspath() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("properties:bar.end?locations=${my.home}/unknown.properties,org/apache/camel/component/properties/bar.properties&ignoreMissingLocation=false");
            }
        });
        try {
            this.context.start();
            PropertiesComponentDefaultTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            PropertiesComponentDefaultTest.assertEquals((String)"Cannot find JVM system property with key: my.home", (String)e.getCause().getCause().getMessage());
        }
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

