/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.properties.DefaultPropertiesResolver;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;

public class PropertiesComponentRestartTest
extends ContextTestSupport {
    private int resolvedCount;

    public void testPropertiesComponentCacheClearedOnStop() throws Exception {
        this.context.start();
        this.context.resolvePropertyPlaceholders("{{cool.end}}");
        this.context.resolvePropertyPlaceholders("{{cool.end}}");
        this.context.resolvePropertyPlaceholders("{{cool.end}}");
        PropertiesComponentRestartTest.assertEquals((int)1, (int)this.resolvedCount);
        this.context.stop();
        this.context.start();
        this.context.resolvePropertyPlaceholders("{{cool.end}}");
        this.context.resolvePropertyPlaceholders("{{cool.end}}");
        this.context.resolvePropertyPlaceholders("{{cool.end}}");
        PropertiesComponentRestartTest.assertEquals((int)2, (int)this.resolvedCount);
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        PropertiesComponent pc = new PropertiesComponent("classpath:org/apache/camel/component/properties/myproperties.properties");
        pc.setPropertiesResolver(new PropertiesResolver(){

            public Properties resolveProperties(CamelContext context, boolean ignoreMissingLocation, String ... uri) throws Exception {
                PropertiesComponentRestartTest.this.resolvedCount++;
                return new DefaultPropertiesResolver().resolveProperties(context, ignoreMissingLocation, uri);
            }
        });
        SimpleRegistry registry = new SimpleRegistry();
        registry.put((Object)"properties", (Object)pc);
        return new DefaultCamelContext((Registry)registry);
    }
}

