/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ref;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;

public class RefFileEndpointTest
extends ContextTestSupport {
    private SimpleRegistry registry = new SimpleRegistry();

    @Override
    protected void setUp() throws Exception {
        RefFileEndpointTest.deleteDirectory("target/foo");
        super.setUp();
    }

    public void testRefFileEndpoint() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("file:target/foo", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        FileConsumer consumer = (FileConsumer)this.context.getRoute("foo").getConsumer();
        RefFileEndpointTest.assertEquals((long)3000L, (long)consumer.getDelay());
        RefFileEndpointTest.assertEquals((long)250L, (long)consumer.getInitialDelay());
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.registry);
        this.registry.put((Object)"foo", (Object)context.getEndpoint("file:target/foo?initialDelay=250&delay=3000&delete=true"));
        return context;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("ref:foo").routeId("foo").to("mock:result");
            }
        };
    }
}

