/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.impl.JndiRegistry;

public class FromRestGetCorsTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    public void testCors() throws Exception {
        this.getMockEndpoint("mock:update").expectedMessageCount(1);
        Exchange out = this.template.request("seda:post-say-bye", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"I was here");
            }
        });
        FromRestGetCorsTest.assertNotNull((Object)out);
        FromRestGetCorsTest.assertEquals((Object)out.getOut().getHeader("Access-Control-Allow-Origin"), (Object)"*");
        FromRestGetCorsTest.assertEquals((Object)out.getOut().getHeader("Access-Control-Allow-Methods"), (Object)"GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, CONNECT, PATCH");
        FromRestGetCorsTest.assertEquals((Object)out.getOut().getHeader("Access-Control-Allow-Headers"), (Object)"Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers");
        FromRestGetCorsTest.assertEquals((Object)out.getOut().getHeader("Access-Control-Max-Age"), (Object)"3600");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().enableCORS(true);
                this.rest("/say/hello").get().to("direct:hello");
                this.rest("/say/bye").get().consumes("application/json").to("direct:bye").post().to("mock:update");
                this.from("direct:hello").transform().constant((Object)"Hello World");
                this.from("direct:bye").transform().constant((Object)"Bye World");
            }
        };
    }
}

