/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ChoiceDefinition;

public class FromRestGetHttpErrorCodeTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    public void testFromRestModel() throws Exception {
        String out = (String)this.template.requestBody("seda:get-say-bye", (Object)"I was here", String.class);
        FromRestGetHttpErrorCodeTest.assertEquals((String)"Bye World", (String)out);
        Exchange reply = this.template.request("seda:get-say-bye", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Kaboom");
            }
        });
        FromRestGetHttpErrorCodeTest.assertNotNull((Object)reply);
        FromRestGetHttpErrorCodeTest.assertEquals((Object)404, (Object)reply.getOut().getHeader("CamelHttpResponseCode"));
        FromRestGetHttpErrorCodeTest.assertEquals((Object)"text/plain", (Object)reply.getOut().getHeader("Content-Type"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.rest("/say/bye").get().route().choice().when(this.body().contains((Object)"Kaboom")).setHeader("CamelHttpResponseCode", (Expression)this.constant(404))).setHeader("Content-Type", (Expression)this.constant("text/plain"))).setBody((Expression)this.constant("The data is invalid"))).otherwise().transform().constant((Object)"Bye World");
            }
        };
    }
}

